/*
 * Decompiled with CFR 0.152.
 */
package net.jadedmc.commandblocker.listeners;

import net.jadedmc.commandblocker.CommandBlockerPlugin;
import net.jadedmc.commandblocker.utils.ChatUtils;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.jetbrains.annotations.NotNull;

public class PlayerCommandPreprocessListener
implements Listener {
    private final CommandBlockerPlugin plugin;

    public PlayerCommandPreprocessListener(@NotNull CommandBlockerPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onCommandPreprocess(@NotNull PlayerCommandPreprocessEvent event) {
        String mode = this.plugin.getConfigManager().getConfig().getString("Mode");
        if (mode == null || mode.equalsIgnoreCase("HIDE")) {
            return;
        }
        if (event.getPlayer().hasPermission("commandblocker.bypass")) {
            return;
        }
        String command = event.getMessage().split(" ")[0];
        if (mode.equalsIgnoreCase("blacklist")) {
            for (String blacklist : this.plugin.getConfigManager().getCommands()) {
                if (command.equalsIgnoreCase(blacklist)) {
                    this.blockCommand(event);
                } else {
                    String fullCommand;
                    if (!blacklist.contains(" ") || !(fullCommand = event.getMessage().toLowerCase()).startsWith(blacklist.toLowerCase()) || !fullCommand.equalsIgnoreCase(blacklist) && !fullCommand.startsWith(blacklist.toLowerCase() + " ")) continue;
                    this.blockCommand(event);
                }
                break;
            }
        } else if (mode.equalsIgnoreCase("whitelist")) {
            for (String whitelist : this.plugin.getConfigManager().getCommands()) {
                if (!command.equalsIgnoreCase(whitelist)) continue;
                return;
            }
            this.blockCommand(event);
        }
    }

    private void blockCommand(@NotNull PlayerCommandPreprocessEvent event) {
        event.setCancelled(true);
        if (this.plugin.getConfigManager().getConfig().isSet("Message") && !this.plugin.getConfigManager().getConfig().getString("Message").isEmpty()) {
            ChatUtils.chat(event.getPlayer(), this.plugin.getConfigManager().getConfig().getString("Message"));
        }
        if (this.plugin.getConfigManager().getConfig().isSet("ActionBar") && !this.plugin.getConfigManager().getConfig().getString("ActionBar").isEmpty()) {
            ChatUtils.getAdventure().player(event.getPlayer()).sendActionBar(ChatUtils.translate(this.plugin.getConfigManager().getConfig().getString("ActionBar")));
        }
        if (this.plugin.getConfigManager().getConfig().isSet("Sound.Sound")) {
            Sound sound = Sound.valueOf((String)this.plugin.getConfigManager().getConfig().getString("Sound.Sound"));
            float volume = (float)this.plugin.getConfigManager().getConfig().getDouble("Sound.Volume");
            float pitch = (float)this.plugin.getConfigManager().getConfig().getDouble("Sound.Pitch");
            event.getPlayer().playSound((Entity)event.getPlayer(), sound, volume, pitch);
        }
    }
}

