/*
 * Decompiled with CFR 0.152.
 */
package net.jadedmc.commandblocker.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.jadedmc.commandblocker.CommandBlockerPlugin;
import net.jadedmc.commandblocker.shaded.adventure.adventure.platform.bukkit.BukkitAudiences;
import net.jadedmc.commandblocker.shaded.adventure.adventure.text.Component;
import net.jadedmc.commandblocker.shaded.adventure.adventure.text.minimessage.MiniMessage;
import net.jadedmc.commandblocker.utils.VersionUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ChatUtils {
    private static BukkitAudiences adventure;
    private static CommandBlockerPlugin plugin;

    public static void initialize(@NotNull CommandBlockerPlugin pl) {
        plugin = pl;
        adventure = BukkitAudiences.create((Plugin)pl);
    }

    public static void disable() {
        if (adventure != null) {
            adventure.close();
            adventure = null;
        }
    }

    public static void chat(@NotNull CommandSender sender, @NotNull String message) {
        adventure.sender(sender).sendMessage(ChatUtils.translate(message));
    }

    public static void chat(@NotNull Player player, @NotNull String message) {
        if (plugin.getHookManager().usePlaceholderAPI()) {
            message = PlaceholderAPI.setPlaceholders((Player)player, (String)message);
        }
        adventure.sender((CommandSender)player).sendMessage(ChatUtils.translate(message));
    }

    public static BukkitAudiences getAdventure() {
        return adventure;
    }

    public static Component translate(@NotNull String message) {
        return MiniMessage.miniMessage().deserialize(ChatUtils.replaceLegacy(message));
    }

    public static String replaceLegacy(@NotNull String message) {
        if (VersionUtils.getServerVersion() >= 16) {
            Pattern pattern = Pattern.compile("&#[a-fA-F0-9]{6}");
            Matcher matcher = pattern.matcher(message);
            while (matcher.find()) {
                String color = message.substring(matcher.start() + 1, matcher.end());
                message = message.replace("&" + color, "<reset><color:" + color + ">");
                matcher = pattern.matcher(message);
            }
        }
        return message.replace("\\n", "<newline>").replace("\u00a7", "&").replace("&0", "<reset><black>").replace("&1", "<reset><dark_blue>").replace("&2", "<reset><dark_green>").replace("&3", "<reset><dark_aqua>").replace("&4", "<reset><dark_red>").replace("&5", "<reset><dark_purple>").replace("&6", "<reset><gold>").replace("&7", "<reset><gray>").replace("&8", "<reset><dark_gray>").replace("&9", "<reset><blue>").replace("&a", "<reset><green>").replace("&b", "<reset><aqua>").replace("&c", "<reset><red>").replace("&d", "<reset><light_purple>").replace("&e", "<reset><yellow>").replace("&f", "<reset><white>").replace("&k", "<obfuscated>").replace("&l", "<bold>").replace("&m", "<strikethrough>").replace("&n", "<u>").replace("&o", "<i>").replace("&r", "<reset>");
    }
}

