/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.fabricmail;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.borisshoes.fabricmail.ConfigUtils;
import net.borisshoes.fabricmail.MailGui;
import net.borisshoes.fabricmail.cardinalcomponents.IMailComponent;
import net.borisshoes.fabricmail.cardinalcomponents.MailMessage;
import net.borisshoes.fabricmail.cardinalcomponents.WorldDataComponentInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11561;
import net.minecraft.class_124;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_5250;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FabricMail
implements ModInitializer {
    private static final Logger logger = LogManager.getLogger((String)"FabricMail");
    private static final String CONFIG_NAME = "FabricMail.properties";
    private static ConfigUtils config;

    public void onInitialize() {
        logger.info("Sending Fabric Mail Your Way!");
        config = new ConfigUtils(FabricLoader.getInstance().getConfigDir().resolve(CONFIG_NAME).toFile(), logger, Arrays.asList(new ConfigUtils.IntegerConfigValue("maxSentParcels", 10, new ConfigUtils.IntegerConfigValue.IntLimits(0, 1024), new ConfigUtils.Command("The maximum amount of outbound parcels is %s", "Set the maximum amount of outbound parcels to %s"))));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, registrationEnvironment) -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mail").then(class_2170.method_9247((String)"gui").executes(FabricMail::gui))).then(class_2170.method_9247((String)"list").executes(FabricMail::list))).then(class_2170.method_9247((String)"outbound").executes(FabricMail::listOutbound))).then(class_2170.method_9247((String)"revoke").then(class_2170.method_9244((String)"mail_id", (ArgumentType)StringArgumentType.string()).executes(context -> FabricMail.revoke((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"mail_id")))))).then(class_2170.method_9247((String)"read").then(class_2170.method_9244((String)"mail_id", (ArgumentType)StringArgumentType.string()).executes(context -> FabricMail.read((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"mail_id")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"mail_id", (ArgumentType)StringArgumentType.string()).executes(context -> FabricMail.delete((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"mail_id"))))).then(class_2170.method_9247((String)"all").executes(context -> FabricMail.delete((CommandContext<class_2168>)context, "all"))))).then(class_2170.method_9247((String)"send").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests(this::getRecipientSuggestions).then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> FabricMail.send((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"message"), false)))))).then(class_2170.method_9247((String)"parcel").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests(this::getRecipientSuggestions).then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> FabricMail.send((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"message"), true)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"broadcast").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"offline").then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> FabricMail.broadcast((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"message"), false, true, false))))).then(class_2170.method_9247((String)"online").then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> FabricMail.broadcast((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"message"), true, false, false))))).then(class_2170.method_9247((String)"all").then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> FabricMail.broadcast((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"message"), true, true, false)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"airdrop").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"offline").then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> FabricMail.broadcast((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"message"), false, true, true))))).then(class_2170.method_9247((String)"online").then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> FabricMail.broadcast((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"message"), true, false, true))))).then(class_2170.method_9247((String)"all").then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> FabricMail.broadcast((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"message"), true, true, true))))));
            dispatcher.register(config.generateCommand("mailconfig"));
        });
    }

    private CompletableFuture<Suggestions> getRecipientSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        String start = builder.getRemaining().toLowerCase(Locale.ROOT);
        ArrayList<String> playerNames = new ArrayList<String>(((class_2168)context.getSource()).method_9211().method_3760().method_14571().stream().map(class_1657::method_5820).toList());
        if (((class_2168)context.getSource()).method_43737()) {
            playerNames.removeIf(name -> name.equals(((class_2168)context.getSource()).method_44023().method_5820()));
        }
        playerNames.stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(start)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static int broadcast(CommandContext<class_2168> context, String message, boolean online, boolean offline, boolean parcel) {
        class_11561 baseCache;
        class_2520 element;
        Object player;
        class_1799 stack;
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        IMailComponent mailbox = (IMailComponent)WorldDataComponentInitializer.MAILS.get((Object)server.method_30002());
        if (!source.method_43737() && parcel) {
            source.method_45068((class_2561)class_2561.method_43470((String)"Only a player can broadcast with a parcel").method_27692(class_124.field_1061));
            return -1;
        }
        if (message.length() > 1024) {
            source.method_45068((class_2561)class_2561.method_43470((String)"Message Length Exceeds 1024 Characters").method_27692(class_124.field_1061));
            return -1;
        }
        class_2487 parcelTag = new class_2487();
        if (parcel && !(stack = (player = source.method_44023()).method_6047()).method_7960() && (element = (class_2520)class_1799.field_24671.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)((class_2168)context.getSource()).method_30497()), (Object)stack).getOrThrow()) instanceof class_2487) {
            class_2487 compound;
            parcelTag = compound = (class_2487)element;
            if (!player.method_68878()) {
                player.method_31548().method_7378(stack);
            }
        }
        if (online) {
            for (class_3222 player2 : server.method_3760().method_14571()) {
                MailMessage newMail = new MailMessage(new GameProfile(UUID.fromString("291af7c7-2114-45bb-a97a-d3b4077392e8"), "System"), player2.method_7334().name(), player2.method_7334().id(), message, UUID.randomUUID(), System.currentTimeMillis(), parcelTag);
                newMail.checkValid(server);
                mailbox.addMail(newMail);
                player2.method_64398((class_2561)class_2561.method_43470((String)"You Just Received Mail!").method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609("/mail read " + newMail.uuid().toString())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Click to View Your Mail! (Mail ID: " + newMail.uuid().toString() + ")")))).method_10977(class_124.field_1076)));
            }
        }
        if (offline && (baseCache = server.method_73550().comp_4407()) instanceof class_3312) {
            class_3312 userCache = (class_3312)baseCache;
            List cacheEntries = userCache.method_14517();
            for (class_3312.class_3313 cacheEntry : cacheEntries) {
                Optional opt = server.method_73550().comp_4624().method_73290(cacheEntry.method_72369().comp_4422());
                if (opt.isEmpty() || server.method_3760().method_14602(cacheEntry.method_72369().comp_4422()) != null) continue;
                MailMessage newMail = new MailMessage(new GameProfile(UUID.fromString("291af7c7-2114-45bb-a97a-d3b4077392e8"), "System"), cacheEntry.method_72369().comp_4423(), cacheEntry.method_72369().comp_4422(), message, UUID.randomUUID(), System.currentTimeMillis(), parcelTag);
                newMail.checkValid(server);
                mailbox.addMail(newMail);
            }
        }
        source.method_45068((class_2561)class_2561.method_43470((String)"Message Sent!").method_27692(class_124.field_1075));
        logger.log(Level.INFO, "The Following Mail was Broadcast: " + message);
        return 1;
    }

    private static int gui(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        if (source.method_43737() && server != null) {
            MailGui mailGui = new MailGui(source.method_44023());
            mailGui.buildMailboxGui();
            mailGui.open();
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"Only players can open a mail GUI"));
        return -1;
    }

    private static int list(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        if (source.method_43737() && server != null) {
            IMailComponent mailbox = (IMailComponent)WorldDataComponentInitializer.MAILS.get((Object)server.method_30002());
            class_3222 player = source.method_44023();
            List<MailMessage> mails = mailbox.getMailsFor(player);
            player.method_64398((class_2561)class_2561.method_43470((String)""));
            player.method_64398((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You have ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)("" + mails.size())).method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" messages (").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"Click to read OR type /mail gui").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1075)));
            int i = 0;
            while (i < mails.size()) {
                MailMessage mail = mails.get(i);
                class_5250 mailText = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("(" + (i + 1) + ") ")).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"From: ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)(mail.sender() + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)mail.getTimeDiff(System.currentTimeMillis())).method_27692(class_124.field_1065));
                if (!mail.parcel().method_33133()) {
                    mailText.method_10852((class_2561)class_2561.method_43470((String)" {Contains Parcel}").method_27692(class_124.field_1060));
                }
                int finalI = i++;
                player.method_64398((class_2561)mailText.method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609("/mail read " + mail.uuid().toString())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Click to Read Mail #" + (finalI + 1)))))));
            }
            player.method_64398((class_2561)class_2561.method_43470((String)""));
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"Only players can receive mail"));
        return -1;
    }

    private static int listOutbound(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        if (source.method_43737() && server != null) {
            IMailComponent mailbox = (IMailComponent)WorldDataComponentInitializer.MAILS.get((Object)server.method_30002());
            class_3222 player = source.method_44023();
            List<MailMessage> mails = mailbox.getMailsFrom(player);
            player.method_64398((class_2561)class_2561.method_43470((String)""));
            player.method_64398((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You have ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)("" + mails.size())).method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" outbound messages ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"(Click to Un-send OR type /mail gui)").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)":").method_27692(class_124.field_1075)));
            for (int i = 0; i < mails.size(); ++i) {
                MailMessage mail = mails.get(i);
                class_5250 mailText = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("(" + (i + 1) + ") ")).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"To: ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)(mail.recipient() + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)mail.getTimeDiff(System.currentTimeMillis())).method_27692(class_124.field_1065));
                if (!mail.parcel().method_33133()) {
                    mailText.method_10852((class_2561)class_2561.method_43470((String)" {Contains Parcel}").method_27692(class_124.field_1060));
                }
                player.method_64398((class_2561)mailText.method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609("/mail revoke " + mail.uuid().toString())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to Revoke this Mail")))));
            }
            player.method_64398((class_2561)class_2561.method_43470((String)""));
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"Only players can send mail"));
        return -1;
    }

    private static int send(CommandContext<class_2168> context, String to, String message, boolean parcel) {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        if (source.method_43737() && server != null) {
            IMailComponent mailbox = (IMailComponent)WorldDataComponentInitializer.MAILS.get((Object)server.method_30002());
            class_3222 player = source.method_44023();
            if (message.length() > 1024) {
                player.method_64398((class_2561)class_2561.method_43470((String)"Message Length Exceeds 1024 Characters").method_27692(class_124.field_1061));
                return -1;
            }
            class_2487 parcelTag = new class_2487();
            class_1799 stack = class_1799.field_8037;
            if (parcel) {
                class_2520 element;
                stack = player.method_6047();
                if (!stack.method_7960() && (element = (class_2520)class_1799.field_24671.encodeStart((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)((class_2168)context.getSource()).method_30497()), (Object)stack).getOrThrow()) instanceof class_2487) {
                    class_2487 compound;
                    parcelTag = compound = (class_2487)element;
                }
                List<MailMessage> mails = mailbox.getMailsFrom(player);
                int maxOutbound = (Integer)config.getValue("maxSentParcels");
                int outbound = 0;
                for (MailMessage mail : mails) {
                    if (mail.parcel() == null || mail.parcel().method_33133()) continue;
                    ++outbound;
                }
                if (outbound >= maxOutbound) {
                    source.method_9213((class_2561)class_2561.method_43470((String)"You have reached the maximum amount of outbound parcels!"));
                    return -1;
                }
            }
            class_3222 onlineTo = server.method_3760().method_14566(to);
            MailMessage newMail = new MailMessage(player.method_7334(), to, onlineTo == null ? null : onlineTo.method_5667(), message, UUID.randomUUID(), System.currentTimeMillis(), parcelTag);
            if (newMail.sender().equals(newMail.recipient())) {
                source.method_9213((class_2561)class_2561.method_43470((String)"You cannot send a mail to yourself!"));
                return -1;
            }
            if (newMail.checkValid(server)) {
                if (!stack.method_7960() && !player.method_68878()) {
                    player.method_31548().method_7378(stack);
                }
                mailbox.addMail(newMail);
                class_3222 recipient = player.method_51469().method_8503().method_3760().method_14566(to);
                if (recipient != null) {
                    MailMessage mail;
                    List<MailMessage> mails = mailbox.getMailsFor(recipient);
                    for (int i = 0; i < mails.size() && !(mail = mails.get(i)).uuid().equals(newMail.uuid()); ++i) {
                    }
                    recipient.method_64398((class_2561)class_2561.method_43470((String)"You Just Received Mail!").method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609("/mail read " + newMail.uuid().toString())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Click to View Your Mail! (Mail ID: " + newMail.uuid().toString() + ")")))).method_10977(class_124.field_1076)));
                }
                player.method_64398((class_2561)class_2561.method_43470((String)"Message Sent!").method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609("/mail revoke " + newMail.uuid().toString())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Click to Revoke (Mail ID: " + newMail.uuid().toString() + ")")))).method_10977(class_124.field_1075)));
                logger.log(Level.INFO, player.method_5820() + " sent mail to " + to + ": " + message);
            } else {
                source.method_9213((class_2561)class_2561.method_43470((String)"Recipient Does Not Exist"));
            }
            return -1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"Only players can send mail"));
        return -1;
    }

    private static int delete(CommandContext<class_2168> context, String mailIDStr) {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        if (source.method_43737() && server != null) {
            IMailComponent mailbox = (IMailComponent)WorldDataComponentInitializer.MAILS.get((Object)server.method_30002());
            class_3222 player = source.method_44023();
            List<MailMessage> mails = mailbox.getMailsFor(player);
            if (mailIDStr.equals("all")) {
                mailbox.clearMailFor(player);
                player.method_64398((class_2561)class_2561.method_43470((String)"All Mail Deleted").method_27692(class_124.field_1076));
                return 1;
            }
            UUID mailID = FabricMail.getIdOrNull(mailIDStr);
            if (mailID == null) {
                player.method_64398((class_2561)class_2561.method_43470((String)"Invalid Mail ID").method_27692(class_124.field_1061));
                return -1;
            }
            MailMessage mail = mailbox.getMail(mailID.toString());
            if (mail != null && mail.recipientId().equals(player.method_5667())) {
                mailbox.removeMail(mailID.toString());
                player.method_64398((class_2561)class_2561.method_43470((String)"Mail Deleted").method_27692(class_124.field_1076));
                return 1;
            }
            player.method_64398((class_2561)class_2561.method_43470((String)"Invalid Mail ID").method_27692(class_124.field_1061));
            return -1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"Only players can delete mail"));
        return -1;
    }

    private static int revoke(CommandContext<class_2168> context, String mailIDStr) {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        if (source.method_43737() && server != null) {
            IMailComponent mailbox = (IMailComponent)WorldDataComponentInitializer.MAILS.get((Object)server.method_30002());
            class_3222 player = source.method_44023();
            List<MailMessage> mails = mailbox.getMailsFrom(player);
            UUID mailID = FabricMail.getIdOrNull(mailIDStr);
            if (mailID == null) {
                player.method_64398((class_2561)class_2561.method_43470((String)"Invalid Mail ID").method_27692(class_124.field_1061));
                return -1;
            }
            for (MailMessage mail : mails) {
                if (!mail.uuid().equals(mailID) || !mail.senderId().equals(player.method_5667())) continue;
                if (!mail.parcel().method_33133()) {
                    player.method_64398((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Revoked Mail to ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)mail.recipient()).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" and returned the Parcel to your Inventory.").method_27692(class_124.field_1076)));
                } else {
                    player.method_64398((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Revoked Mail to ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)mail.recipient()).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1076)));
                }
                FabricMail.givePlayerStack(player, mail.popParcel((class_7225.class_7874)((class_2168)context.getSource()).method_30497()));
                mailbox.removeMail(mail.uuid().toString());
                return 1;
            }
            player.method_64398((class_2561)class_2561.method_43470((String)"Invalid Mail ID").method_27692(class_124.field_1061));
            return -1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"Only players can receive mail"));
        return -1;
    }

    private static int read(CommandContext<class_2168> context, String mailIDStr) {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        if (source.method_43737() && server != null) {
            IMailComponent mailbox = (IMailComponent)WorldDataComponentInitializer.MAILS.get((Object)server.method_30002());
            class_3222 player = source.method_44023();
            List<MailMessage> mails = mailbox.getMailsFor(player);
            UUID mailID = FabricMail.getIdOrNull(mailIDStr);
            if (mailID == null) {
                player.method_64398((class_2561)class_2561.method_43470((String)"Invalid Mail ID").method_27692(class_124.field_1061));
                return -1;
            }
            MailMessage mail = mailbox.getMail(mailID.toString());
            if (mail != null && mail.recipientId().equals(player.method_5667())) {
                player.method_64398((class_2561)class_2561.method_43470((String)""));
                player.method_64398((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"From: ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)(mail.sender() + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)mail.getTimeDiff(System.currentTimeMillis())).method_27692(class_124.field_1065)));
                player.method_64398((class_2561)class_2561.method_43470((String)mail.message()).method_27692(class_124.field_1075));
                player.method_64398((class_2561)class_2561.method_43470((String)""));
                if (!mail.parcel().method_33133()) {
                    player.method_64398((class_2561)class_2561.method_43470((String)"This Mail contained a Parcel. It has been added to your Inventory.").method_27695(new class_124[]{class_124.field_1060, class_124.field_1056}));
                }
                player.method_64398((class_2561)class_2561.method_43470((String)"[Click to remove message from your mailbox]").method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609("/mail delete " + String.valueOf(mailID))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to Delete Mail"))).method_10977(class_124.field_1076)));
                FabricMail.givePlayerStack(player, mail.popParcel((class_7225.class_7874)((class_2168)context.getSource()).method_30497()));
                return 1;
            }
            player.method_64398((class_2561)class_2561.method_43470((String)"Invalid Mail ID").method_27692(class_124.field_1061));
            return -1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"Only players can receive mail"));
        return -1;
    }

    public static void informMail(class_3222 player) {
        MinecraftServer server = player.method_51469().method_8503();
        IMailComponent mailbox = (IMailComponent)WorldDataComponentInitializer.MAILS.get((Object)server.method_30002());
        List<MailMessage> mails = mailbox.getMailsFor(player);
        if (mails.isEmpty()) {
            return;
        }
        player.method_64398((class_2561)class_2561.method_43470((String)""));
        player.method_64398((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You have ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)("" + mails.size())).method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" messages").method_27692(class_124.field_1075)));
        player.method_64398((class_2561)class_2561.method_43470((String)"[Click here to view OR type /mail gui]").method_27694(s -> s.method_10958((class_2558)new class_2558.class_10610("/mail list")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to View Your Mail!"))).method_10977(class_124.field_1076)));
        player.method_64398((class_2561)class_2561.method_43470((String)""));
    }

    public static void givePlayerStack(class_3222 player, class_1799 stack) {
        boolean bl = player.method_31548().method_7394(stack);
        if (!bl || !stack.method_7960()) {
            class_1542 itemEntity = player.method_7328(stack, false);
            if (itemEntity == null) {
                return;
            }
            itemEntity.method_6975();
            itemEntity.method_48349(player.method_5667());
            return;
        }
        stack.method_7939(1);
        class_1542 itemEntity = player.method_7328(stack, false);
        if (itemEntity != null) {
            itemEntity.method_6987();
        }
    }

    public static UUID getIdOrNull(String id) {
        try {
            return UUID.fromString(id);
        }
        catch (Exception e) {
            return null;
        }
    }
}

