/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.fabricmail;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.borisshoes.fabricmail.FabricMail;
import net.borisshoes.fabricmail.cardinalcomponents.IMailComponent;
import net.borisshoes.fabricmail.cardinalcomponents.MailMessage;
import net.borisshoes.fabricmail.cardinalcomponents.WorldDataComponentInitializer;
import net.minecraft.class_124;
import net.minecraft.class_1713;
import net.minecraft.class_1802;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_7225;

public class MailGui
extends SimpleGui {
    private MailSort sortType;
    private MailFilter filterType;
    private int page = 1;
    private boolean outboundMode;
    private List<MailMessage> mailList;

    public MailGui(class_3222 player) {
        super(class_3917.field_17327, player, false);
        this.setTitle((class_2561)class_2561.method_43470((String)"Your Mail Inbox"));
        this.outboundMode = false;
        this.sortType = MailSort.RECENT_FIRST;
        this.filterType = MailFilter.NONE;
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        boolean indexInCenter;
        boolean bl = indexInCenter = index > 9 && index < 45 && index % 9 != 0 && index % 9 != 8;
        if (index == 4) {
            this.outboundMode = !this.outboundMode;
            this.buildMailboxGui();
        } else if (index == 0) {
            boolean backwards = type == ClickType.MOUSE_RIGHT;
            boolean shiftLeft = type == ClickType.MOUSE_LEFT_SHIFT;
            this.sortType = shiftLeft ? MailSort.RECENT_FIRST : MailSort.cycleSort(this.sortType, backwards);
            this.buildMailboxGui();
        } else if (index == 8) {
            boolean backwards = type == ClickType.MOUSE_RIGHT;
            boolean shiftLeft = type == ClickType.MOUSE_LEFT_SHIFT;
            this.filterType = shiftLeft ? MailFilter.NONE : MailFilter.cycleFilter(this.filterType, backwards);
            this.mailList = this.sortedFilteredMailList();
            int numPages = (int)Math.ceil((double)this.mailList.size() / 28.0);
            if (this.page > numPages) {
                this.page = Math.max(1, numPages);
            }
            this.buildMailboxGui();
        } else if (index == 45) {
            if (this.page > 1) {
                --this.page;
                this.buildMailboxGui();
            }
        } else if (index == 53) {
            int numPages = (int)Math.ceil((double)this.mailList.size() / 28.0);
            if (this.page < numPages) {
                ++this.page;
                this.buildMailboxGui();
            }
        } else if (indexInCenter) {
            boolean shiftLeft;
            int ind = 7 * (index / 9 - 1) + (index % 9 - 1) + 28 * (this.page - 1);
            if (ind >= this.mailList.size()) {
                return true;
            }
            IMailComponent mailbox = (IMailComponent)WorldDataComponentInitializer.MAILS.get((Object)this.player.method_51469().method_8503().method_30002());
            MailMessage mail = this.mailList.get(ind);
            boolean right = type == ClickType.MOUSE_RIGHT;
            boolean bl2 = shiftLeft = type == ClickType.MOUSE_LEFT_SHIFT;
            if (this.outboundMode) {
                if (!mail.parcel().method_33133()) {
                    this.player.method_64398((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Revoked Mail to ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)mail.recipient()).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" and returned the Parcel to your Inventory.").method_27692(class_124.field_1076)));
                } else {
                    this.player.method_64398((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Revoked Mail to ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)mail.recipient()).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1076)));
                }
                FabricMail.givePlayerStack(this.player, mail.popParcel((class_7225.class_7874)this.player.method_56673()));
                mailbox.removeMail(mail.uuid().toString());
            } else if (right) {
                mailbox.removeMail(mail.uuid().toString());
                this.player.method_64398((class_2561)class_2561.method_43470((String)("Deleted Mail " + mail.uuid().toString())).method_27692(class_124.field_1076));
            } else if (shiftLeft) {
                this.player.method_64398((class_2561)class_2561.method_43470((String)""));
                this.player.method_64398((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"From: ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)(mail.sender() + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)mail.getTimeDiff(System.currentTimeMillis())).method_27692(class_124.field_1065)));
                this.player.method_64398((class_2561)class_2561.method_43470((String)mail.message()).method_27692(class_124.field_1075));
                this.player.method_64398((class_2561)class_2561.method_43470((String)""));
                if (!mail.parcel().method_33133()) {
                    this.player.method_64398((class_2561)class_2561.method_43470((String)"This Mail contained a Parcel. It has been added to your Inventory.").method_27695(new class_124[]{class_124.field_1060, class_124.field_1056}));
                }
                FabricMail.givePlayerStack(this.player, mail.popParcel((class_7225.class_7874)this.player.method_56673()));
                mailbox.removeMail(mail.uuid().toString());
                this.player.method_64398((class_2561)class_2561.method_43470((String)("Deleted Mail " + mail.uuid().toString())).method_27692(class_124.field_1076));
            } else {
                this.player.method_64398((class_2561)class_2561.method_43470((String)""));
                this.player.method_64398((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"From: ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)(mail.sender() + " ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)mail.getTimeDiff(System.currentTimeMillis())).method_27692(class_124.field_1065)));
                this.player.method_64398((class_2561)class_2561.method_43470((String)mail.message()).method_27692(class_124.field_1075));
                this.player.method_64398((class_2561)class_2561.method_43470((String)""));
                if (!mail.parcel().method_33133()) {
                    this.player.method_64398((class_2561)class_2561.method_43470((String)"This Mail contained a Parcel. It has been added to your Inventory.").method_27695(new class_124[]{class_124.field_1060, class_124.field_1056}));
                }
                this.player.method_64398((class_2561)class_2561.method_43470((String)"[Click to remove message from your mailbox]").method_27694(s -> s.method_10958((class_2558)new class_2558.class_10609("/mail delete " + mail.uuid().toString())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to Delete Mail"))).method_10977(class_124.field_1076)));
                FabricMail.givePlayerStack(this.player, mail.popParcel((class_7225.class_7874)this.player.method_56673()));
            }
            this.buildMailboxGui();
        }
        return true;
    }

    public void buildMailboxGui() {
        this.mailList = this.sortedFilteredMailList();
        if (this.outboundMode) {
            this.setTitle((class_2561)class_2561.method_43470((String)"Your Mail Outbox"));
        } else {
            this.setTitle((class_2561)class_2561.method_43470((String)"Your Mail Inbox"));
        }
        int numPages = (int)Math.ceil((double)this.mailList.size() / 28.0);
        for (int i = 0; i < this.getSize(); ++i) {
            GuiElementBuilder pane = new GuiElementBuilder(class_1802.field_8747).hideTooltip();
            this.setSlot(i, (GuiElementBuilderInterface)pane);
        }
        GuiElementBuilder nextArrow = new GuiElementBuilder(class_1802.field_8236).hideDefaultTooltip();
        nextArrow.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Next Page").method_27692(class_124.field_1065)));
        nextArrow.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("(" + this.page + " of " + numPages + ")")).method_27692(class_124.field_1064))));
        this.setSlot(53, (GuiElementBuilderInterface)nextArrow);
        GuiElementBuilder prevArrow = new GuiElementBuilder(class_1802.field_8236).hideDefaultTooltip();
        prevArrow.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Prev Page").method_27692(class_124.field_1065)));
        prevArrow.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)("(" + this.page + " of " + numPages + ")")).method_27692(class_124.field_1064))));
        this.setSlot(45, (GuiElementBuilderInterface)prevArrow);
        GuiElementBuilder modeButton = new GuiElementBuilder(this.outboundMode ? class_1802.field_8674 : class_1802.field_8360).hideDefaultTooltip();
        modeButton.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(this.outboundMode ? "Outbox Mode" : "Inbox Mode")).method_27692(class_124.field_1075)));
        modeButton.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)(this.outboundMode ? "Showing you your outbound mails" : "Showing you your inbound mails")).method_27692(class_124.field_1064)));
        modeButton.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"")));
        modeButton.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to toggle the mailbox mode").method_27692(class_124.field_1076))));
        this.setSlot(4, (GuiElementBuilderInterface)modeButton);
        GuiElementBuilder filterBuilt = new GuiElementBuilder(class_1802.field_8239).hideDefaultTooltip();
        filterBuilt.setName((class_2561)class_2561.method_43470((String)"Filter Mail").method_27692(class_124.field_1064));
        filterBuilt.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to change current filter.").method_27692(class_124.field_1076))));
        filterBuilt.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to cycle filter backwards.").method_27692(class_124.field_1076))));
        filterBuilt.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shift Left Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to reset filter.").method_27692(class_124.field_1076))));
        filterBuilt.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"")));
        filterBuilt.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Current Filter: ").method_27692(class_124.field_1075)).method_10852(MailFilter.getColoredLabel(this.filterType))));
        this.setSlot(8, (GuiElementBuilderInterface)filterBuilt);
        GuiElementBuilder sortBuilt = new GuiElementBuilder(class_1802.field_8137).hideDefaultTooltip();
        sortBuilt.setName((class_2561)class_2561.method_43470((String)"Sort Mail").method_27692(class_124.field_1064));
        sortBuilt.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to change current sort type.").method_27692(class_124.field_1076))));
        sortBuilt.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to cycle sort backwards.").method_27692(class_124.field_1076))));
        sortBuilt.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shift Left Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to reset sort.").method_27692(class_124.field_1076))));
        sortBuilt.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"")));
        sortBuilt.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sorting By: ").method_27692(class_124.field_1075)).method_10852(MailSort.getColoredLabel(this.sortType))));
        this.setSlot(0, (GuiElementBuilderInterface)sortBuilt);
        int k = (this.page - 1) * 28;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (k < this.mailList.size() && k >= 0) {
                    MailMessage mail = this.mailList.get(k);
                    boolean hasParcel = !mail.parcel().method_33133();
                    GuiElementBuilder mailItem = new GuiElementBuilder(hasParcel ? class_1802.field_8106 : class_1802.field_8407).hideDefaultTooltip();
                    if (this.outboundMode) {
                        mailItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Mail to: ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)mail.recipient()).method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})));
                        mailItem.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)mail.getTimeDiff(System.currentTimeMillis())).method_27692(class_124.field_1065)));
                        if (!mail.parcel().method_33133()) {
                            mailItem.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"< Contains Parcel >").method_27692(class_124.field_1060)));
                        }
                        mailItem.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"")));
                        mailItem.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to REVOKE this mail").method_27692(class_124.field_1061))));
                    } else {
                        mailItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Mail from: ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)mail.sender()).method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})));
                        mailItem.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)mail.getTimeDiff(System.currentTimeMillis())).method_27692(class_124.field_1065)));
                        if (!mail.parcel().method_33133()) {
                            mailItem.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"< Contains Parcel >").method_27692(class_124.field_1060)));
                        }
                        mailItem.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"")));
                        mailItem.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to READ this mail").method_27692(class_124.field_1076))));
                        mailItem.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shift Click").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to READ AND DELETE this mail").method_27692(class_124.field_1065))));
                        mailItem.addLoreLine((class_2561)MailGui.removeItalics(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to DELETE this mail").method_27692(class_124.field_1061))));
                    }
                    this.setSlot(i * 9 + 10 + j, (GuiElementBuilderInterface)mailItem);
                } else {
                    this.setSlot(i * 9 + 10 + j, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8162));
                }
                ++k;
            }
        }
    }

    private List<MailMessage> sortedFilteredMailList() {
        IMailComponent mailbox = (IMailComponent)WorldDataComponentInitializer.MAILS.get((Object)this.player.method_51469().method_8503().method_30002());
        List<MailMessage> mails = this.outboundMode ? mailbox.getMailsFrom(this.player) : mailbox.getMailsFor(this.player);
        ArrayList<MailMessage> sortedFiltered = new ArrayList<MailMessage>(mails.stream().filter(mail -> MailFilter.matchesFilter(this.player, this.filterType, mail)).toList());
        MailSort mailSort = this.sortType;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"RECENT_LAST"}, (MailSort)mailSort, n)) {
            case 0: {
                sortedFiltered.sort(Comparator.comparingLong(MailMessage::timestamp));
                break;
            }
            default: {
                sortedFiltered.sort(Comparator.comparingLong(mail -> -mail.timestamp()));
            }
        }
        return sortedFiltered;
    }

    private static class_5250 removeItalics(class_5250 text) {
        class_2583 parentStyle = class_2583.field_24360.method_10977(class_124.field_1064).method_10978(Boolean.valueOf(false)).method_10982(Boolean.valueOf(false)).method_30938(Boolean.valueOf(false)).method_36141(Boolean.valueOf(false)).method_36140(Boolean.valueOf(false));
        return text.method_10862(text.method_10866().method_27702(parentStyle));
    }

    public static enum MailSort {
        RECENT_FIRST("Recent First"),
        RECENT_LAST("Recent Last");

        public final String label;

        private MailSort(String label) {
            this.label = label;
        }

        public static class_2561 getColoredLabel(MailSort sort) {
            class_5250 text = class_2561.method_43470((String)sort.label);
            return switch (sort.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> text.method_27692(class_124.field_1075);
                case 1 -> text.method_27692(class_124.field_1060);
            };
        }

        public static MailSort cycleSort(MailSort sort, boolean backwards) {
            MailSort[] sorts = MailSort.values();
            int ind = -1;
            for (int i = 0; i < sorts.length; ++i) {
                if (sort != sorts[i]) continue;
                ind = i;
            }
            if ((ind += backwards ? -1 : 1) >= sorts.length) {
                ind = 0;
            }
            if (ind < 0) {
                ind = sorts.length - 1;
            }
            return sorts[ind];
        }
    }

    public static enum MailFilter {
        NONE("None"),
        HAS_PARCEL("Has Parcel"),
        NO_PARCEL("No Parcel");

        public final String label;

        private MailFilter(String label) {
            this.label = label;
        }

        public static class_2561 getColoredLabel(MailFilter filter) {
            class_5250 text = class_2561.method_43470((String)filter.label);
            return switch (filter.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> text.method_27692(class_124.field_1068);
                case 1 -> text.method_27692(class_124.field_1060);
                case 2 -> text.method_27692(class_124.field_1061);
            };
        }

        public static MailFilter cycleFilter(MailFilter filter, boolean backwards) {
            MailFilter[] filters = MailFilter.values();
            int ind = -1;
            for (int i = 0; i < filters.length; ++i) {
                if (filter != filters[i]) continue;
                ind = i;
            }
            if ((ind += backwards ? -1 : 1) >= filters.length) {
                ind = 0;
            }
            if (ind < 0) {
                ind = filters.length - 1;
            }
            return filters[ind];
        }

        public static boolean matchesFilter(class_3222 player, MailFilter filter, MailMessage mail) {
            boolean hasParcel;
            if (filter == NONE) {
                return true;
            }
            boolean bl = hasParcel = !mail.parcel().method_33133();
            if (filter == HAS_PARCEL) {
                return hasParcel;
            }
            if (filter == NO_PARCEL) {
                return !hasParcel;
            }
            return false;
        }
    }
}

