/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.fabricmail.cardinalcomponents;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.borisshoes.fabricmail.FabricMail;
import net.borisshoes.fabricmail.cardinalcomponents.IMailComponent;
import net.borisshoes.fabricmail.cardinalcomponents.MailMessage;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_11560;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;

public class MailComponent
implements IMailComponent {
    private final List<MailMessage> mails = new ArrayList<MailMessage>();

    public void readData(class_11368 view) {
        try {
            this.mails.clear();
            for (class_2487 mailTag : view.method_71437("Mails", class_2487.field_25128)) {
                GameProfile senderProf = new GameProfile(FabricMail.getIdOrNull(mailTag.method_68564("fromId", "")), mailTag.method_68564("from", ""));
                this.mails.add(new MailMessage(senderProf, mailTag.method_68564("to", ""), FabricMail.getIdOrNull(mailTag.method_68564("toId", "")), mailTag.method_68564("message", ""), UUID.fromString(mailTag.method_68564("id", "")), mailTag.method_68080("time", 0L), mailTag.method_10562("parcel").orElse(new class_2487())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeData(class_11372 view) {
        try {
            class_11372.class_11373 listAppender = view.method_71467("Mails", class_2487.field_25128);
            for (MailMessage mail : this.mails) {
                class_2487 mailTag = new class_2487();
                mailTag.method_10582("from", mail.sender());
                mailTag.method_10582("fromId", mail.senderId() == null ? "" : mail.senderId().toString());
                mailTag.method_10582("to", mail.recipient());
                mailTag.method_10582("toId", mail.recipientId() == null ? "" : mail.recipientId().toString());
                mailTag.method_10582("message", mail.message());
                mailTag.method_10582("id", mail.uuid().toString());
                mailTag.method_10544("time", mail.timestamp());
                mailTag.method_10566("parcel", (class_2520)mail.parcel());
                listAppender.method_71484((Object)mailTag);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<MailMessage> getMails() {
        return this.mails;
    }

    @Override
    public boolean addMail(MailMessage mail) {
        if (this.mails.stream().anyMatch(m -> mail.uuid().equals(m.uuid()))) {
            return false;
        }
        return this.mails.add(mail);
    }

    @Override
    public boolean removeMail(String mailId) {
        return this.mails.removeIf(m -> UUID.fromString(mailId).equals(m.uuid()));
    }

    @Override
    public MailMessage getMail(String mailId) {
        Optional<MailMessage> opt = this.mails.stream().filter(m -> UUID.fromString(mailId).equals(m.uuid())).findFirst();
        return opt.orElse(null);
    }

    @Override
    public List<MailMessage> getMailsFor(class_3222 player) {
        this.mails.removeIf(mail -> !mail.checkValid(player.method_51469().method_8503()));
        return this.mails.stream().filter(mail -> {
            class_11560 p = mail.findRecipient(player.method_51469().method_8503());
            return p != null && p.comp_4422().equals(player.method_5667());
        }).toList();
    }

    @Override
    public List<MailMessage> getMailsFrom(class_3222 player) {
        this.mails.removeIf(mail -> !mail.checkValid(player.method_51469().method_8503()));
        return this.mails.stream().filter(mail -> mail.senderId().equals(player.method_5667())).toList();
    }

    @Override
    public void clearMailFor(class_3222 player) {
        this.mails.removeIf(mail -> !mail.checkValid(player.method_51469().method_8503()));
        this.mails.removeIf(mail -> {
            class_11560 p = mail.findRecipient(player.method_51469().method_8503());
            return p != null && p.comp_4422().equals(player.method_5667());
        });
    }
}

