/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.fabricmail.cardinalcomponents;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import java.util.UUID;
import net.minecraft.class_11560;
import net.minecraft.class_11561;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_3312;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class MailMessage {
    private final String sender;
    private UUID senderId;
    private final String recipient;
    private UUID recipientId;
    private final String message;
    private final UUID uuid;
    private final long timestamp;
    private class_2487 parcel;

    public MailMessage(GameProfile senderProfile, String recipient, @Nullable UUID recipientId, String message, UUID uuid, long timestamp, class_2487 parcel) {
        this.senderId = senderProfile.id();
        this.sender = senderProfile.name();
        this.recipient = recipient;
        this.recipientId = recipientId;
        this.message = message;
        this.uuid = uuid;
        this.timestamp = timestamp;
        this.parcel = parcel;
    }

    public String sender() {
        return this.sender;
    }

    public UUID senderId() {
        return this.senderId;
    }

    public String recipient() {
        return this.recipient;
    }

    public UUID recipientId() {
        return this.recipientId;
    }

    public String message() {
        return this.message;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public class_2487 parcel() {
        return this.parcel;
    }

    public boolean checkValid(MinecraftServer server) {
        class_11560 profile = this.findRecipient(server);
        return profile != null;
    }

    public class_11560 findRecipient(MinecraftServer server) {
        class_11561 baseCache = server.method_73550().comp_4407();
        if (!(baseCache instanceof class_3312)) {
            return null;
        }
        class_3312 userCache = (class_3312)baseCache;
        if (this.recipientId != null && this.recipient != null) {
            return new class_11560(this.recipientId, this.recipient);
        }
        class_11560 entry = userCache.method_14515(this.recipient).orElse(null);
        if (entry != null && this.recipientId == null && entry.comp_4422() != null) {
            this.recipientId = entry.comp_4422();
        }
        return entry;
    }

    public String getTimeDiff(long curTime) {
        long timeDiff;
        long subtract = timeDiff = (curTime - this.timestamp) / 1000L;
        long daysDif = subtract / 86400L;
        long hoursDif = (subtract -= daysDif * 86400L) / 3600L;
        long minutesDif = (subtract -= hoursDif * 3600L) / 60L;
        long secondsDiff = subtract -= minutesDif * 60L;
        Object diff = "Sent [";
        if (daysDif > 0L) {
            diff = (String)diff + daysDif + " Days ";
        }
        if (hoursDif > 0L) {
            diff = (String)diff + hoursDif + " Hours ";
        }
        if (minutesDif > 0L) {
            diff = (String)diff + minutesDif + " Minutes ";
        }
        if (secondsDiff > 0L) {
            diff = (String)diff + secondsDiff + " Seconds ";
        }
        diff = ((String)diff).substring(0, ((String)diff).length() - 1);
        diff = (String)diff + "] Ago";
        return diff;
    }

    private class_1799 peekParcel(class_7225.class_7874 registryLookup) {
        return class_1799.field_24671.parse((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)registryLookup), (Object)this.parcel).result().orElse(class_1799.field_8037);
    }

    public class_1799 popParcel(class_7225.class_7874 registryLookup) {
        class_1799 stack = class_1799.field_24671.parse((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)registryLookup), (Object)this.parcel).result().orElse(class_1799.field_8037);
        this.parcel = new class_2487();
        return stack;
    }
}

