/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.vialoader.netty.viabedrock;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.net.InetSocketAddress;
import java.util.List;
import org.cloudburstmc.netty.channel.raknet.RakPing;
import org.cloudburstmc.netty.channel.raknet.RakPong;

public class PingEncapsulationCodec
extends MessageToMessageCodec<RakPong, ByteBuf> {
    private final InetSocketAddress remoteAddress;

    public PingEncapsulationCodec(InetSocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        short packetId = in.readUnsignedByte();
        if (packetId != 1) {
            ctx.close();
            throw new IllegalStateException("Unexpected packet ID: " + packetId);
        }
        out.add(new RakPing(in.readLong(), this.remoteAddress));
    }

    protected void decode(ChannelHandlerContext ctx, RakPong in, List<Object> out) {
        if (!this.remoteAddress.equals(in.getSender())) {
            ctx.close();
            throw new IllegalStateException("Received pong from unexpected address: " + String.valueOf(in.getSender()));
        }
        ByteBuf buf = ctx.alloc().buffer();
        buf.writeByte(28);
        buf.writeLong(in.getPingTime());
        buf.writeBytes(in.getPongData());
        out.add(buf);
    }
}

