/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viaforge.common;

import com.viaversion.vialoader.ViaLoader;
import com.viaversion.vialoader.impl.platform.ViaAprilFoolsPlatformImpl;
import com.viaversion.vialoader.impl.platform.ViaBackwardsPlatformImpl;
import com.viaversion.vialoader.impl.platform.ViaLegacyPlatformImpl;
import com.viaversion.vialoader.impl.platform.ViaRewindPlatformImpl;
import com.viaversion.vialoader.netty.CompressionReorderEvent;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.connection.ConnectionDetails;
import com.viaversion.viaversion.connection.UserConnectionImpl;
import com.viaversion.viaversion.protocol.ProtocolPipelineImpl;
import de.florianmichael.viaforge.common.platform.VFPlatform;
import de.florianmichael.viaforge.common.platform.ViaForgeConfig;
import de.florianmichael.viaforge.common.protocoltranslator.ViaForgeVLInjector;
import de.florianmichael.viaforge.common.protocoltranslator.ViaForgeVLLoader;
import de.florianmichael.viaforge.common.protocoltranslator.netty.VFNetworkManager;
import de.florianmichael.viaforge.common.protocoltranslator.netty.ViaForgeVLLegacyPipeline;
import de.florianmichael.viaforge.common.protocoltranslator.platform.ViaForgeViaVersionPlatformImpl;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.util.AttributeKey;
import java.io.File;

public class ViaForgeCommon {
    public static final AttributeKey<UserConnection> VF_VIA_USER = AttributeKey.valueOf((String)"viaforge_via_user");
    public static final AttributeKey<VFNetworkManager> VF_NETWORK_MANAGER = AttributeKey.valueOf((String)"viaforge_network_manager");
    private static ViaForgeCommon manager;
    private final VFPlatform platform;
    private ProtocolVersion targetVersion;
    private ProtocolVersion previousVersion;
    private ViaForgeConfig config;

    public ViaForgeCommon(VFPlatform platform) {
        this.platform = platform;
    }

    public static void init(VFPlatform platform) {
        ProtocolVersion version = ProtocolVersion.getProtocol(platform.getGameVersion());
        if (version == ProtocolVersion.unknown) {
            throw new IllegalArgumentException("Unknown version " + platform.getGameVersion());
        }
        manager = new ViaForgeCommon(platform);
        File mainFolder = new File(platform.getLeadingDirectory(), "ViaForge");
        ViaLoader.init(new ViaForgeViaVersionPlatformImpl(mainFolder), new ViaForgeVLLoader(platform), new ViaForgeVLInjector(), null, ViaBackwardsPlatformImpl::new, ViaRewindPlatformImpl::new, ViaLegacyPlatformImpl::new, ViaAprilFoolsPlatformImpl::new);
        ViaForgeCommon.manager.config = new ViaForgeConfig(new File(mainFolder, "viaforge.yml"), Via.getPlatform().getLogger());
        ProtocolVersion configVersion = ProtocolVersion.getClosest(ViaForgeCommon.manager.config.getClientSideVersion());
        if (configVersion != null) {
            manager.setTargetVersion(configVersion);
        } else {
            manager.setTargetVersion(version);
        }
    }

    public void inject(Channel channel, VFNetworkManager networkManager) {
        if (networkManager.viaForge$getTrackedVersion().equals(this.getNativeVersion())) {
            return;
        }
        channel.attr(VF_NETWORK_MANAGER).set((Object)networkManager);
        UserConnectionImpl user = new UserConnectionImpl(channel, true);
        new ProtocolPipelineImpl(user);
        channel.attr(VF_VIA_USER).set((Object)user);
        channel.pipeline().addLast(new ChannelHandler[]{new ViaForgeVLLegacyPipeline(user, this.targetVersion)});
        channel.closeFuture().addListener(future -> {
            if (this.previousVersion != null) {
                this.restoreVersion();
            }
        });
    }

    public void sendConnectionDetails(Channel channel) {
        if (!this.config.isSendConnectionDetails() || !channel.hasAttr(VF_VIA_USER)) {
            return;
        }
        ConnectionDetails.sendConnectionDetails((UserConnection)channel.attr(VF_VIA_USER).get(), "vv:mod_details");
    }

    public void reorderCompression(Channel channel) {
        channel.pipeline().fireUserEventTriggered((Object)CompressionReorderEvent.INSTANCE);
    }

    public ProtocolVersion getNativeVersion() {
        return ProtocolVersion.getProtocol(this.platform.getGameVersion());
    }

    public ProtocolVersion getTargetVersion() {
        return this.targetVersion;
    }

    public void restoreVersion() {
        this.targetVersion = ProtocolVersion.getClosest(this.config.getClientSideVersion());
    }

    public void setTargetVersionSilent(ProtocolVersion targetVersion) {
        if (targetVersion == null) {
            throw new IllegalArgumentException("Target version cannot be null");
        }
        ProtocolVersion oldVersion = this.targetVersion;
        this.targetVersion = targetVersion;
        if (oldVersion != targetVersion) {
            this.previousVersion = oldVersion;
        }
    }

    public void setTargetVersion(ProtocolVersion targetVersion) {
        if (targetVersion == null) {
            throw new IllegalArgumentException("Target version cannot be null");
        }
        this.targetVersion = targetVersion;
        this.config.setClientSideVersion(targetVersion.getName());
    }

    public VFPlatform getPlatform() {
        return this.platform;
    }

    public ViaForgeConfig getConfig() {
        return this.config;
    }

    public static ViaForgeCommon getManager() {
        return manager;
    }
}

