/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.codec.Ops;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.util.Copyable;
import com.viaversion.viaversion.util.Rewritable;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Objects;
import viaforge-mc189.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@RecordComponents(value={@RecordComponents.Value(name="type", type=int.class), @RecordComponents.Value(name="tag", type=CompoundTag.class)})
@NestMembers(value={1.class})
public final class EntityData
extends J_L_Record
implements Rewritable,
Copyable {
    private final int type;
    private final CompoundTag tag;
    public static final Type<EntityData> TYPE = new Type<EntityData>(EntityData.class){

        @Override
        public EntityData read(ByteBuf buffer) {
            int type = Types.VAR_INT.readPrimitive(buffer);
            CompoundTag tag = (CompoundTag)Types.COMPOUND_TAG.read(buffer);
            return new EntityData(type, tag);
        }

        @Override
        public void write(ByteBuf buffer, EntityData value) {
            Types.VAR_INT.writePrimitive(buffer, value.jvmdowngrader$nest$com_viaversion_viaversion_api_minecraft_item_data_EntityData$get$type());
            Types.COMPOUND_TAG.write(buffer, value.jvmdowngrader$nest$com_viaversion_viaversion_api_minecraft_item_data_EntityData$get$tag());
        }

        @Override
        public void write(Ops ops, EntityData data) {
            ops.writeMap(map -> map.write("id", Types.RESOURCE_LOCATION, ops.context().registryAccess().entity(data.jvmdowngrader$nest$com_viaversion_viaversion_api_minecraft_item_data_EntityData$get$type())).writeInlinedMap(Types.COMPOUND_TAG, data.jvmdowngrader$nest$com_viaversion_viaversion_api_minecraft_item_data_EntityData$get$tag()));
        }
    };

    public EntityData(int type, CompoundTag tag) {
        this.type = type;
        this.tag = tag;
    }

    @Override
    public EntityData rewrite(UserConnection connection, Protocol<?, ?, ?, ?> protocol, boolean clientbound) {
        int mappedType = protocol.getMappingData().getEntityMappings().getNewId(this.type);
        return new EntityData(mappedType, this.tag);
    }

    @Override
    public EntityData copy() {
        return new EntityData(this.type, this.tag.copy());
    }

    @Override
    public final String toString() {
        return EntityData.jvmdowngrader$toString$toString(this);
    }

    @Override
    public final int hashCode() {
        return EntityData.jvmdowngrader$hashCode$hashCode(this);
    }

    @Override
    public final boolean equals(Object o) {
        return EntityData.jvmdowngrader$equals$equals(this, o);
    }

    public int type() {
        return this.type;
    }

    public CompoundTag tag() {
        return this.tag;
    }

    private static /* synthetic */ String jvmdowngrader$toString$toString(EntityData entityData) {
        EntityData entityData2 = entityData;
        return "EntityData[" + "type=" + entityData.type + ", " + "tag=" + entityData.tag + "]";
    }

    private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(EntityData entityData) {
        Object[] objectArray = new Object[]{entityData.type, entityData.tag};
        return Arrays.hashCode(objectArray);
    }

    private static /* synthetic */ boolean jvmdowngrader$equals$equals(EntityData entityData, Object object) {
        if (entityData == object) {
            return true;
        }
        if (object != null && object instanceof EntityData) {
            EntityData entityData2 = (EntityData)object;
            if (entityData.type == entityData2.type && Objects.equals(entityData.tag, entityData2.tag)) {
                return true;
            }
        }
        return false;
    }

    public /* synthetic */ int jvmdowngrader$nest$com_viaversion_viaversion_api_minecraft_item_data_EntityData$get$type() {
        return this.type;
    }

    public /* synthetic */ void jvmdowngrader$nest$com_viaversion_viaversion_api_minecraft_item_data_EntityData$set$type(int n) {
        this.type = n;
    }

    public /* synthetic */ CompoundTag jvmdowngrader$nest$com_viaversion_viaversion_api_minecraft_item_data_EntityData$get$tag() {
        return this.tag;
    }

    public /* synthetic */ void jvmdowngrader$nest$com_viaversion_viaversion_api_minecraft_item_data_EntityData$set$tag(CompoundTag compoundTag) {
        this.tag = compoundTag;
    }
}

