/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.protocol.packet;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.configuration.RateLimitConfig;
import com.viaversion.viaversion.api.configuration.ViaVersionConfig;
import com.viaversion.viaversion.api.connection.UserConnection;
import java.util.Arrays;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={RateTracker.class})
public class PacketTracker {
    private static final long SECOND_NANOS = 1000000000L;
    private final RateTracker packetTracker = new RateTracker(5);
    private final RateTracker packetSizeTracker = new RateTracker(3);
    private long startTime = System.nanoTime();
    private boolean packetLimiterEnabled = true;
    private final UserConnection connection;
    private long sentPacketsTotal;
    private long receivedPacketsTotal;

    public PacketTracker(UserConnection connection) {
        this.connection = connection;
    }

    public void incrementSent() {
        ++this.sentPacketsTotal;
    }

    @Deprecated(forRemoval=true)
    public boolean incrementReceived() {
        return this.incrementReceived(0);
    }

    public boolean incrementReceived(int packetSize) {
        ++this.receivedPacketsTotal;
        ViaVersionConfig config = Via.getConfig();
        long currentTime = System.nanoTime();
        long elapsed = currentTime - this.startTime;
        if (elapsed < 1000000000L) {
            if (config.getPacketTrackerConfig().enabled()) {
                this.packetTracker.addIntervalValue(1);
            }
            if (config.getPacketSizeTrackerConfig().enabled()) {
                this.packetSizeTracker.addIntervalValue(packetSize);
            }
            return false;
        }
        if (config.getPacketTrackerConfig().enabled()) {
            this.packetTracker.updateRate(elapsed);
            this.packetTracker.addIntervalValue(1);
        }
        if (config.getPacketSizeTrackerConfig().enabled()) {
            this.packetSizeTracker.updateRate(elapsed);
            this.packetSizeTracker.addIntervalValue(packetSize);
        }
        this.startTime = currentTime;
        return true;
    }

    public boolean exceedsLimits() {
        if (this.connection.isClientSide()) {
            return false;
        }
        ViaVersionConfig config = Via.getConfig();
        return this.packetTracker.exceedsLimit(this.connection, config.getPacketTrackerConfig()) || this.packetSizeTracker.exceedsLimit(this.connection, config.getPacketSizeTrackerConfig());
    }

    public long getSentPackets() {
        return this.sentPacketsTotal;
    }

    @Deprecated(forRemoval=true)
    public void setSentPackets(long sentPackets) {
        this.sentPacketsTotal = sentPackets;
    }

    public long getReceivedPackets() {
        return this.receivedPacketsTotal;
    }

    @Deprecated(forRemoval=true)
    public void setReceivedPackets(long receivedPackets) {
        this.receivedPacketsTotal = receivedPackets;
    }

    @Deprecated(forRemoval=true)
    public long getIntervalPackets() {
        return this.packetTracker.intervalValue;
    }

    @Deprecated(forRemoval=true)
    public void setIntervalPackets(long intervalPackets) {
        this.packetTracker.intervalValue = Math.toIntExact(intervalPackets);
    }

    public int getPacketsPerSecond() {
        return this.packetTracker.jvmdowngrader$nest$com_viaversion_viaversion_api_protocol_packet_PacketTracker$RateTracker$get$currentRate();
    }

    public boolean isPacketLimiterEnabled() {
        ViaVersionConfig config = Via.getConfig();
        return this.packetLimiterEnabled && config.getPacketTrackerConfig().enabled() && config.getPacketSizeTrackerConfig().enabled();
    }

    public void setPacketLimiterEnabled(boolean packetLimiterEnabled) {
        this.packetLimiterEnabled = packetLimiterEnabled;
    }

    @Deprecated(forRemoval=true)
    public void setWarnings(int warnings) {
        this.packetTracker.jvmdowngrader$nest$com_viaversion_viaversion_api_protocol_packet_PacketTracker$RateTracker$set$warnings(warnings);
    }

    public void reset() {
        this.sentPacketsTotal = 0L;
        this.receivedPacketsTotal = 0L;
        this.startTime = System.nanoTime();
        this.packetTracker.reset();
        this.packetSizeTracker.reset();
    }

    @NestHost(value=PacketTracker.class)
    private static final class RateTracker {
        private final int[] history;
        private int historyIndex;
        private int historyCount;
        private int currentRate = -1;
        int intervalValue;
        private long warningPeriodStart = System.nanoTime();
        private int warnings;

        public RateTracker(int windowSize) {
            this.history = new int[windowSize];
        }

        public void addIntervalValue(int value) {
            this.intervalValue += value;
        }

        public void updateRate(long elapsedNanos) {
            this.history[this.historyIndex] = (int)((long)this.intervalValue * 1000000000L / elapsedNanos);
            this.historyIndex = (this.historyIndex + 1) % this.history.length;
            if (this.historyCount < this.history.length) {
                ++this.historyCount;
            }
            int sum = 0;
            for (int i = 0; i < this.historyCount; ++i) {
                sum += this.history[i];
            }
            this.currentRate = sum / this.historyCount;
            this.intervalValue = 0;
        }

        public boolean exceedsLimit(UserConnection connection, RateLimitConfig limitConfig) {
            if (!limitConfig.enabled() || this.currentRate < 0) {
                return false;
            }
            if (limitConfig.maxRate() > 0 && this.currentRate >= limitConfig.maxRate()) {
                connection.disconnect(limitConfig.maxRateKickMessage().replace(limitConfig.ratePlaceholder(), Integer.toString(this.currentRate)));
                return true;
            }
            if (limitConfig.maxWarnings() > 0 && limitConfig.trackingPeriodNanos() > 0L && limitConfig.warningRate() > 0) {
                return this.checkTrackedInterval(connection, limitConfig);
            }
            return false;
        }

        private boolean checkTrackedInterval(UserConnection connection, RateLimitConfig config) {
            long currentTime = System.nanoTime();
            if (currentTime - this.warningPeriodStart >= config.trackingPeriodNanos()) {
                this.warnings = 0;
                this.warningPeriodStart = currentTime;
                return false;
            }
            if (this.currentRate >= config.warningRate() && ++this.warnings >= config.maxWarnings()) {
                connection.disconnect(config.warningKickMessage().replace(config.ratePlaceholder(), Integer.toString(this.currentRate)));
                return true;
            }
            return false;
        }

        public void reset() {
            this.intervalValue = 0;
            this.currentRate = -1;
            this.warnings = 0;
            this.warningPeriodStart = System.nanoTime();
            this.historyIndex = 0;
            this.historyCount = 0;
            Arrays.fill(this.history, 0);
        }

        public /* synthetic */ int jvmdowngrader$nest$com_viaversion_viaversion_api_protocol_packet_PacketTracker$RateTracker$get$currentRate() {
            return this.currentRate;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_viaversion_viaversion_api_protocol_packet_PacketTracker$RateTracker$set$currentRate(int n) {
            this.currentRate = n;
        }

        public /* synthetic */ int jvmdowngrader$nest$com_viaversion_viaversion_api_protocol_packet_PacketTracker$RateTracker$get$warnings() {
            return this.warnings;
        }

        public /* synthetic */ void jvmdowngrader$nest$com_viaversion_viaversion_api_protocol_packet_PacketTracker$RateTracker$set$warnings(int n) {
            this.warnings = n;
        }
    }
}

