/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocol.release.r1_7_6_10tor1_8.provider;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.viaversion.viaversion.api.minecraft.GameProfile;
import com.viaversion.viaversion.api.platform.providers.Provider;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.raphimc.vialegacy.ViaLegacy;
import net.raphimc.vialegacy.api.util.GameProfileUtil;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={2.class, 1.class})
public abstract class GameProfileFetcher
implements Provider {
    private static final GameProfile NULL_GAME_PROFILE = new GameProfile(null, null);
    private static final Pattern COLOR_CODE_PATTERN = Pattern.compile("(?i)\\u00A7[0-9A-FK-OR]");
    private final LoadingCache<String, UUID> uuidCache = CacheBuilder.newBuilder().expireAfterWrite(6L, TimeUnit.HOURS).build(new CacheLoader<String, UUID>(){

        @Override
        public UUID load(String key) throws Exception {
            return GameProfileFetcher.this.loadMojangUuid(key);
        }
    });
    private final LoadingCache<UUID, GameProfile> gameProfileCache = CacheBuilder.newBuilder().expireAfterWrite(6L, TimeUnit.HOURS).build(new CacheLoader<UUID, GameProfile>(){

        @Override
        public GameProfile load(UUID key) throws Exception {
            return GameProfileFetcher.this.loadGameProfile(key);
        }
    });

    public boolean isUuidLoaded(String playerName) {
        return this.uuidCache.getIfPresent(playerName) != null;
    }

    public UUID getMojangUuid(String playerName) {
        playerName = COLOR_CODE_PATTERN.matcher(playerName).replaceAll("");
        try {
            return this.uuidCache.get(playerName);
        }
        catch (Throwable e) {
            while (e instanceof ExecutionException || e instanceof UncheckedExecutionException || e instanceof CompletionException || e instanceof ExecutionError) {
                e = e.getCause();
            }
            ViaLegacy.getPlatform().getLogger().log(Level.WARNING, GameProfileFetcher.jvmdowngrader$concat$getMojangUuid$1(playerName, e.getClass().getName()));
            UUID uuid = GameProfileUtil.getOfflinePlayerUuid(playerName);
            this.uuidCache.put(playerName, uuid);
            return uuid;
        }
    }

    public CompletableFuture<UUID> getMojangUuidAsync(String playerName) {
        if (this.isUuidLoaded(playerName)) {
            return CompletableFuture.completedFuture(this.getMojangUuid(playerName));
        }
        return CompletableFuture.supplyAsync(() -> this.getMojangUuid(playerName));
    }

    public boolean isGameProfileLoaded(UUID uuid) {
        return this.gameProfileCache.getIfPresent(uuid) != null;
    }

    public GameProfile getGameProfile(UUID uuid) {
        try {
            GameProfile value = this.gameProfileCache.get(uuid);
            if (NULL_GAME_PROFILE.equals(value)) {
                return null;
            }
            return value;
        }
        catch (Throwable e) {
            while (e instanceof ExecutionException || e instanceof UncheckedExecutionException || e instanceof CompletionException || e instanceof ExecutionError) {
                e = e.getCause();
            }
            ViaLegacy.getPlatform().getLogger().log(Level.WARNING, GameProfileFetcher.jvmdowngrader$concat$getGameProfile$1(String.valueOf(uuid), e.getClass().getName()));
            this.gameProfileCache.put(uuid, NULL_GAME_PROFILE);
            return null;
        }
    }

    public CompletableFuture<GameProfile> getGameProfileAsync(UUID uuid) {
        if (this.isGameProfileLoaded(uuid)) {
            return CompletableFuture.completedFuture(this.getGameProfile(uuid));
        }
        return CompletableFuture.supplyAsync(() -> this.getGameProfile(uuid));
    }

    public abstract UUID loadMojangUuid(String var1) throws Exception;

    public abstract GameProfile loadGameProfile(UUID var1) throws Exception;

    private static /* synthetic */ String jvmdowngrader$concat$getMojangUuid$1(String string, String string2) {
        return "Failed to load uuid for player '" + string + "' (" + string2 + ")";
    }

    private static /* synthetic */ String jvmdowngrader$concat$getGameProfile$1(String string, String string2) {
        return "Failed to load game profile for uuid '" + string + "' (" + string2 + ")";
    }
}

