/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viaforge.provider;

import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.viaversion.viaversion.api.minecraft.GameProfile;
import java.net.Proxy;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.raphimc.vialegacy.protocol.release.r1_7_6_10tor1_8.provider.GameProfileFetcher;

public class ViaForgeGameProfileFetcher
extends GameProfileFetcher {
    private static final HttpAuthenticationService AUTHENTICATION_SERVICE = new YggdrasilAuthenticationService(Proxy.NO_PROXY, "");
    private static final MinecraftSessionService SESSION_SERVICE = AUTHENTICATION_SERVICE.createMinecraftSessionService();
    private static final GameProfileRepository GAME_PROFILE_REPOSITORY = AUTHENTICATION_SERVICE.createProfileRepository();

    @Override
    public UUID loadMojangUuid(String playerName) throws Exception {
        final CompletableFuture future = new CompletableFuture();
        GAME_PROFILE_REPOSITORY.findProfilesByNames(new String[]{playerName}, Agent.MINECRAFT, new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile profile) {
                future.complete(profile);
            }

            public void onProfileLookupFailed(GameProfile profile, Exception exception) {
                future.completeExceptionally(exception);
            }
        });
        if (!future.isDone()) {
            future.completeExceptionally((Throwable)new ProfileNotFoundException());
        }
        return ((GameProfile)future.get()).getId();
    }

    @Override
    public com.viaversion.viaversion.api.minecraft.GameProfile loadGameProfile(UUID uuid) {
        GameProfile inProfile = new GameProfile(uuid, null);
        GameProfile mojangProfile = SESSION_SERVICE.fillProfileProperties(inProfile, true);
        if (mojangProfile.equals((Object)inProfile)) {
            throw new ProfileNotFoundException();
        }
        GameProfile.Property[] properties = new GameProfile.Property[mojangProfile.getProperties().size()];
        int i = 0;
        for (Map.Entry entry : mojangProfile.getProperties().entries()) {
            properties[i++] = new GameProfile.Property(((Property)entry.getValue()).getName(), ((Property)entry.getValue()).getValue(), ((Property)entry.getValue()).getSignature());
        }
        return new com.viaversion.viaversion.api.minecraft.GameProfile(mojangProfile.getName(), mojangProfile.getId(), properties);
    }
}

