/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viaforge.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.viaversion.vialoader.util.ProtocolVersionList;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.util.DumpUtil;
import de.florianmichael.viaforge.common.ViaForgeCommon;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class GuiProtocolSelector
extends Screen {
    public final Screen parent;
    public final boolean simple;
    public final FinishedCallback finishedCallback;
    private String status;
    private long time;

    public static void open(Minecraft minecraft) {
        minecraft.setScreen((Screen)new GuiProtocolSelector(minecraft.screen));
    }

    public GuiProtocolSelector(Screen parent) {
        this(parent, false, (version, unused) -> ViaForgeCommon.getManager().setTargetVersion(version));
    }

    public GuiProtocolSelector(Screen parent, boolean simple, FinishedCallback finishedCallback) {
        super((Component)Component.literal((String)"ViaForge Protocol Selector"));
        this.parent = parent;
        this.simple = simple;
        this.finishedCallback = finishedCallback;
    }

    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<-"), b -> this.minecraft.setScreen(this.parent)).bounds(5, this.height - 25, 20, 20).build());
        if (!this.simple) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Create dump"), b -> {
                try {
                    this.minecraft.keyboardHandler.setClipboard(DumpUtil.postDump(UUID.randomUUID()).get());
                    this.setStatus(String.valueOf(ChatFormatting.GREEN) + "Dump created and copied to clipboard");
                }
                catch (InterruptedException | ExecutionException e) {
                    this.setStatus(String.valueOf(ChatFormatting.RED) + "Failed to create dump: " + e.getMessage());
                }
            }).bounds(this.width - 105, 5, 100, 20).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Reload configs"), b -> Via.getManager().getConfigurationProvider().reloadConfigs()).bounds(this.width - 105, this.height - 25, 100, 20).build());
        }
        Objects.requireNonNull(this.font);
        Objects.requireNonNull(this.font);
        this.addRenderableWidget((GuiEventListener)new SlotList(this.minecraft, this.width, this.height, 6 + (9 + 2) * 3, 30, 9 + 2));
    }

    public void setStatus(String status) {
        this.status = status;
        this.time = System.currentTimeMillis();
    }

    public boolean keyPressed(int keyCode, int scanCode, int actions) {
        if (keyCode == 256) {
            this.minecraft.setScreen(this.parent);
        }
        return super.keyPressed(keyCode, scanCode, actions);
    }

    public void render(GuiGraphics graphics, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        if (System.currentTimeMillis() - this.time >= 10000L) {
            this.status = null;
        }
        super.render(graphics, p_230430_2_, p_230430_3_, p_230430_4_);
        PoseStack pose = graphics.pose();
        pose.pushPose();
        pose.scale(2.0f, 2.0f, 2.0f);
        graphics.drawCenteredString(this.font, String.valueOf(ChatFormatting.GOLD) + "ViaForge", this.width / 4, 3, 0xFFFFFF);
        pose.popPose();
        int n = this.width / 2;
        Objects.requireNonNull(this.font);
        graphics.drawCenteredString(this.font, "https://github.com/ViaVersion/ViaForge", n, (9 + 2) * 2 + 3, -1);
        graphics.drawString(this.font, this.status != null ? this.status : "Discord: florianmichael", 3, 3, -1);
    }

    public static interface FinishedCallback {
        public void finished(ProtocolVersion var1, Screen var2);
    }

    class SlotList
    extends ObjectSelectionList<SlotEntry> {
        public SlotList(Minecraft client, int width, int height, int top, int bottom, int slotHeight) {
            super(client, width, height - top - bottom, top, slotHeight);
            for (ProtocolVersion version : ProtocolVersionList.getProtocolsNewToOld()) {
                this.addEntry((AbstractSelectionList.Entry)new SlotEntry(version));
            }
        }

        public class SlotEntry
        extends ObjectSelectionList.Entry<SlotEntry> {
            private final ProtocolVersion ProtocolVersion;

            public SlotEntry(ProtocolVersion ProtocolVersion2) {
                this.ProtocolVersion = ProtocolVersion2;
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                GuiProtocolSelector.this.finishedCallback.finished(this.ProtocolVersion, GuiProtocolSelector.this.parent);
                return super.mouseClicked(mouseX, mouseY, button);
            }

            public Component getNarration() {
                return Component.literal((String)this.ProtocolVersion.getName());
            }

            public void render(GuiGraphics graphics, int p_93524_, int y, int p_93526_, int p_93527_, int p_93528_, int p_93529_, int p_93530_, boolean p_93531_, float p_93532_) {
                ProtocolVersion targetVersion = ViaForgeCommon.getManager().getTargetVersion();
                String color = targetVersion == this.ProtocolVersion ? (GuiProtocolSelector.this.simple ? ChatFormatting.GOLD.toString() : ChatFormatting.GREEN.toString()) : (GuiProtocolSelector.this.simple ? ChatFormatting.WHITE.toString() : ChatFormatting.DARK_RED.toString());
                graphics.drawCenteredString(Minecraft.getInstance().font, color + this.ProtocolVersion.getName(), SlotList.this.width / 2, y, -1);
            }
        }
    }
}

