/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.v1_21to1_20_5.rewriter;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viabackwards.api.BackwardsProtocol;
import com.viaversion.viabackwards.api.rewriters.BackwardsRegistryRewriter;
import com.viaversion.viabackwards.api.rewriters.EntityRewriter;
import com.viaversion.viabackwards.protocol.v1_21to1_20_5.Protocol1_21To1_20_5;
import com.viaversion.viabackwards.protocol.v1_21to1_20_5.storage.EnchantmentsPaintingsStorage;
import com.viaversion.viabackwards.protocol.v1_21to1_20_5.storage.PlayerRotationStorage;
import com.viaversion.viaversion.api.minecraft.Holder;
import com.viaversion.viaversion.api.minecraft.PaintingVariant;
import com.viaversion.viaversion.api.minecraft.RegistryEntry;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_20_5;
import com.viaversion.viaversion.api.minecraft.entitydata.EntityDataType;
import com.viaversion.viaversion.api.minecraft.entitydata.types.EntityDataTypes1_20_5;
import com.viaversion.viaversion.api.minecraft.entitydata.types.EntityDataTypes1_21;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.version.Types1_20_5;
import com.viaversion.viaversion.api.type.types.version.VersionedTypes;
import com.viaversion.viaversion.protocols.v1_20_3to1_20_5.packet.ServerboundPackets1_20_5;
import com.viaversion.viaversion.protocols.v1_20_5to1_21.data.Paintings1_20_5;
import com.viaversion.viaversion.protocols.v1_20_5to1_21.packet.ClientboundConfigurationPackets1_21;
import com.viaversion.viaversion.protocols.v1_20_5to1_21.packet.ClientboundPacket1_21;
import com.viaversion.viaversion.protocols.v1_20_5to1_21.packet.ClientboundPackets1_21;
import com.viaversion.viaversion.util.Key;
import com.viaversion.viaversion.util.KeyMappings;
import java.util.HashMap;
import java.util.Map;

public final class EntityPacketRewriter1_21
extends EntityRewriter<ClientboundPacket1_21, Protocol1_21To1_20_5> {
    private final Map<String, PaintingData> oldPaintings = new HashMap<String, PaintingData>();

    public EntityPacketRewriter1_21(Protocol1_21To1_20_5 protocol) {
        super(protocol, ((EntityDataTypes1_20_5)((Types1_20_5)protocol.mappedTypes()).entityDataTypes()).optionalComponentType, ((EntityDataTypes1_20_5)((Types1_20_5)protocol.mappedTypes()).entityDataTypes()).booleanType);
        for (int i = 0; i < Paintings1_20_5.PAINTINGS.length; ++i) {
            PaintingVariant painting = Paintings1_20_5.PAINTINGS[i];
            this.oldPaintings.put(painting.assetId(), new PaintingData(painting, i));
        }
    }

    @Override
    public void registerPackets() {
        this.registerTrackerWithData1_19(ClientboundPackets1_21.ADD_ENTITY, EntityTypes1_20_5.FALLING_BLOCK);
        this.registerSetEntityData(ClientboundPackets1_21.SET_ENTITY_DATA);
        this.registerRemoveEntities(ClientboundPackets1_21.REMOVE_ENTITIES);
        BackwardsRegistryRewriter registryDataRewriter = new BackwardsRegistryRewriter((BackwardsProtocol)this.protocol);
        ((Protocol1_21To1_20_5)this.protocol).registerClientbound(ClientboundConfigurationPackets1_21.REGISTRY_DATA, wrapper -> {
            String key = Key.stripMinecraftNamespace(wrapper.passthrough(Types.STRING));
            RegistryEntry[] entries = wrapper.passthrough(Types.REGISTRY_ENTRY_ARRAY);
            boolean paintingVariant = key.equals("painting_variant");
            boolean enchantment = key.equals("enchantment");
            if (paintingVariant || enchantment || key.equals("jukebox_song")) {
                String[] keys = new String[entries.length];
                for (int i = 0; i < entries.length; ++i) {
                    keys[i] = Key.stripMinecraftNamespace(entries[i].key());
                }
                EnchantmentsPaintingsStorage storage = wrapper.user().get(EnchantmentsPaintingsStorage.class);
                if (paintingVariant) {
                    storage.setPaintings(new KeyMappings(keys), this.paintingMappingsForEntries(entries));
                } else if (enchantment) {
                    Tag[] descriptions = new Tag[entries.length];
                    int[] maxLevels = new int[entries.length];
                    for (int i = 0; i < entries.length; ++i) {
                        RegistryEntry entry = entries[i];
                        Tag patt5263$temp = entry.tag();
                        if (!(patt5263$temp instanceof CompoundTag)) continue;
                        CompoundTag tag = (CompoundTag)patt5263$temp;
                        descriptions[i] = tag.get("description");
                        maxLevels[i] = tag.getInt("max_level");
                    }
                    storage.setEnchantments(new KeyMappings(keys), descriptions, maxLevels);
                } else {
                    int[] jukeboxSongMappings = new int[keys.length];
                    for (int i = 0; i < keys.length; ++i) {
                        int itemId;
                        jukeboxSongMappings[i] = itemId = ((Protocol1_21To1_20_5)this.protocol).getMappingData().getFullItemMappings().mappedId("music_disc_" + keys[i]);
                    }
                    storage.setJubeboxSongsToItems(jukeboxSongMappings);
                }
                wrapper.cancel();
            } else {
                registryDataRewriter.trackDimensionAndBiomes(wrapper.user(), key, entries);
            }
        });
        ((Protocol1_21To1_20_5)this.protocol).registerClientbound(ClientboundPackets1_21.LOGIN, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types.INT);
                this.map(Types.BOOLEAN);
                this.map(Types.STRING_ARRAY);
                this.map(Types.VAR_INT);
                this.map(Types.VAR_INT);
                this.map(Types.VAR_INT);
                this.map(Types.BOOLEAN);
                this.map(Types.BOOLEAN);
                this.map(Types.BOOLEAN);
                this.map(Types.VAR_INT);
                this.map(Types.STRING);
                this.handler(EntityPacketRewriter1_21.this.worldDataTrackerHandlerByKey1_20_5(3));
            }
        });
        ((Protocol1_21To1_20_5)this.protocol).registerClientbound(ClientboundPackets1_21.RESPAWN, wrapper -> {
            int dimensionId = wrapper.passthrough(Types.VAR_INT);
            String world = wrapper.passthrough(Types.STRING);
            this.trackWorldDataByKey1_20_5(wrapper.user(), dimensionId, world);
        });
        ((Protocol1_21To1_20_5)this.protocol).registerServerbound(ServerboundPackets1_20_5.MOVE_PLAYER_POS_ROT, wrapper -> {
            wrapper.passthrough(Types.DOUBLE);
            wrapper.passthrough(Types.DOUBLE);
            wrapper.passthrough(Types.DOUBLE);
            this.storePlayerRotation(wrapper);
        });
        ((Protocol1_21To1_20_5)this.protocol).registerServerbound(ServerboundPackets1_20_5.MOVE_PLAYER_ROT, this::storePlayerRotation);
    }

    private void storePlayerRotation(PacketWrapper wrapper) {
        float yaw = wrapper.passthrough(Types.FLOAT).floatValue();
        float pitch = wrapper.passthrough(Types.FLOAT).floatValue();
        wrapper.user().get(PlayerRotationStorage.class).setRotation(yaw, pitch);
    }

    private int[] paintingMappingsForEntries(RegistryEntry[] entries) {
        int[] mappings = new int[entries.length];
        block0: for (int i = 0; i < entries.length; ++i) {
            RegistryEntry entry = entries[i];
            PaintingData paintingData = this.oldPaintings.get(Key.stripMinecraftNamespace(entry.key()));
            if (paintingData != null) {
                mappings[i] = paintingData.id;
                continue;
            }
            if (entry.tag() == null) continue;
            CompoundTag tag = (CompoundTag)entry.tag();
            for (int j = 0; j < Paintings1_20_5.PAINTINGS.length; ++j) {
                PaintingVariant painting = Paintings1_20_5.PAINTINGS[j];
                if (painting.width() != tag.getInt("width") || painting.height() != tag.getInt("height")) continue;
                mappings[i] = j;
                continue block0;
            }
        }
        return mappings;
    }

    @Override
    protected void registerRewrites() {
        EntityDataTypes1_20_5 mappedEntityDataTypes = (EntityDataTypes1_20_5)VersionedTypes.V1_20_5.entityDataTypes;
        this.filter().handler((event, data) -> {
            EntityDataType type = data.dataType();
            if (type == ((EntityDataTypes1_21)VersionedTypes.V1_21.entityDataTypes).wolfVariantType) {
                Holder variant = (Holder)data.value();
                if (variant.hasId()) {
                    data.setTypeAndValue(mappedEntityDataTypes.wolfVariantType, variant.id());
                } else {
                    event.cancel();
                }
            } else if (type == ((EntityDataTypes1_21)VersionedTypes.V1_21.entityDataTypes).paintingVariantType) {
                Holder variant = (Holder)data.value();
                if (variant.hasId()) {
                    EnchantmentsPaintingsStorage storage = event.user().get(EnchantmentsPaintingsStorage.class);
                    int mappedId = storage.mappedPainting(variant.id());
                    data.setTypeAndValue(mappedEntityDataTypes.paintingVariantType, mappedId);
                } else {
                    event.cancel();
                }
            } else {
                data.setDataType(mappedEntityDataTypes.byId(type.typeId()));
            }
        });
        this.registerEntityDataTypeHandler1_20_3(mappedEntityDataTypes.itemType, mappedEntityDataTypes.blockStateType, mappedEntityDataTypes.optionalBlockStateType, mappedEntityDataTypes.particleType, mappedEntityDataTypes.particlesType, mappedEntityDataTypes.componentType, mappedEntityDataTypes.optionalComponentType);
        this.registerBlockStateHandler(EntityTypes1_20_5.ABSTRACT_MINECART, 11);
    }

    @Override
    public EntityType typeFromId(int type) {
        return EntityTypes1_20_5.getTypeFromId(type);
    }

    private record PaintingData(PaintingVariant painting, int id) {
    }
}

