/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.protocols.v1_20_3to1_20_5.storage;

import com.viaversion.viaversion.api.connection.StorableObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ScoreboardTeamStorage
implements StorableObject {
    private final Map<String, Set<String>> teams = new HashMap<String, Set<String>>();

    public void createTeam(String name) {
        if (this.teams.containsKey(name)) {
            return;
        }
        this.teams.put(name, new HashSet());
    }

    public void removeTeam(String name) {
        this.teams.remove(name);
    }

    public void addPlayerToTeam(String team, String[] player) {
        Set players = this.teams.computeIfAbsent(team, k -> new HashSet());
        Collections.addAll(players, player);
    }

    public void removeFromTeam(String team, String player) {
        Set<String> players = this.teams.get(team);
        if (players != null) {
            players.remove(player);
        }
    }

    public String getPlayerTeam(String player) {
        for (Map.Entry<String, Set<String>> entry : this.teams.entrySet()) {
            if (!entry.getValue().contains(player)) continue;
            return entry.getKey();
        }
        return null;
    }
}

