/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viaforge;

import de.florianmichael.viaforge.common.ViaForgeCommon;
import de.florianmichael.viaforge.common.platform.VFPlatform;
import de.florianmichael.viaforge.provider.ViaForgeGameProfileFetcher;
import java.io.File;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.raphimc.vialegacy.protocol.release.r1_7_6_10tor1_8.provider.GameProfileFetcher;

@Mod(value="viaforge")
public class ViaForge1219
implements VFPlatform {
    public ViaForge1219(FMLJavaModLoadingContext context) {
        if (SharedConstants.getProtocolVersion() >= 771) {
            FMLCommonSetupEvent.getBus((BusGroup)context.getModBusGroup()).addListener(this::onInit);
        } else {
            try {
                Object bus = FMLJavaModLoadingContext.class.getDeclaredMethod("getModEventBus", new Class[0]).invoke((Object)context, new Object[0]);
                bus.getClass().getDeclaredMethod("addListener", Consumer.class).invoke(bus, this::onInit);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private void onInit(FMLCommonSetupEvent event) {
        ViaForgeCommon.init(this);
    }

    @Override
    public int getGameVersion() {
        return SharedConstants.getProtocolVersion();
    }

    @Override
    public Supplier<Boolean> isSingleplayer() {
        return () -> Minecraft.getInstance().isSingleplayer();
    }

    @Override
    public File getLeadingDirectory() {
        return Minecraft.getInstance().gameDirectory;
    }

    @Override
    public void joinServer(String serverId) throws Throwable {
        User session = Minecraft.getInstance().getUser();
        Minecraft.getInstance().services().sessionService().joinServer(session.getProfileId(), session.getAccessToken(), serverId);
    }

    @Override
    public GameProfileFetcher getGameProfileFetcher() {
        return new ViaForgeGameProfileFetcher();
    }

    @Override
    public String getDecodeHandlerName() {
        return "inbound_config";
    }
}

