/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viaforge.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.viaversion.vialoader.util.ProtocolVersionList;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.util.DumpUtil;
import de.florianmichael.viaforge.common.ViaForgeCommon;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import org.joml.Matrix3x2fStack;

public class GuiProtocolSelector
extends Screen {
    private static Method viaforge$pose;
    private static Method viaforge$drawString;
    public final Screen parent;
    public final boolean simple;
    public final FinishedCallback finishedCallback;
    private String status;
    private long time;

    public GuiProtocolSelector(Screen parent) {
        this(parent, false, (version, unused) -> ViaForgeCommon.getManager().setTargetVersion(version));
    }

    public GuiProtocolSelector(Screen parent, boolean simple, FinishedCallback finishedCallback) {
        super((Component)Component.literal((String)"ViaForge Protocol Selector"));
        this.parent = parent;
        this.simple = simple;
        this.finishedCallback = finishedCallback;
    }

    public static void open(Minecraft minecraft) {
        minecraft.setScreen((Screen)new GuiProtocolSelector(minecraft.screen));
    }

    private static void drawString(GuiGraphics graphics, Font font, String s) {
        if (SharedConstants.getProtocolVersion() >= 771) {
            graphics.drawString(font, s, 3, 3, -1);
        } else {
            try {
                if (viaforge$drawString == null) {
                    viaforge$drawString = GuiGraphics.class.getDeclaredMethod("drawString", Font.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                }
                viaforge$drawString.invoke((Object)graphics, font, s, 3, 3, -1);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<-"), b -> this.minecraft.setScreen(this.parent)).bounds(5, this.height - 25, 20, 20).build());
        if (!this.simple) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Create dump"), b -> {
                try {
                    this.minecraft.keyboardHandler.setClipboard(DumpUtil.postDump(UUID.randomUUID()).get());
                    this.setStatus(String.valueOf(ChatFormatting.GREEN) + "Dump created and copied to clipboard");
                }
                catch (InterruptedException | ExecutionException e) {
                    this.setStatus(String.valueOf(ChatFormatting.RED) + "Failed to create dump: " + e.getMessage());
                }
            }).bounds(this.width - 105, 5, 100, 20).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Reload configs"), b -> Via.getManager().getConfigurationProvider().reloadConfigs()).bounds(this.width - 105, this.height - 25, 100, 20).build());
        }
        Objects.requireNonNull(this.font);
        Objects.requireNonNull(this.font);
        this.addRenderableWidget((GuiEventListener)new SlotList(this.minecraft, this.width, this.height, 6 + (9 + 2) * 3, 30, 9 + 2));
    }

    public void setStatus(String status) {
        this.status = status;
        this.time = System.currentTimeMillis();
    }

    public boolean keyPressed(KeyEvent p_423266_) {
        if (p_423266_.isEscape()) {
            this.minecraft.setScreen(this.parent);
        }
        return super.keyPressed(p_423266_);
    }

    public void render(GuiGraphics graphics, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        if (System.currentTimeMillis() - this.time >= 10000L) {
            this.status = null;
        }
        super.render(graphics, p_230430_2_, p_230430_3_, p_230430_4_);
        if (SharedConstants.getProtocolVersion() >= 771) {
            Matrix3x2fStack pose = graphics.pose();
            pose.pushMatrix();
            pose.scale(2.0f, 2.0f);
            graphics.drawCenteredString(this.font, String.valueOf(ChatFormatting.GOLD) + "ViaForge", this.width / 4, 3, -1);
            pose.popMatrix();
        } else {
            try {
                if (viaforge$pose == null) {
                    viaforge$pose = GuiGraphics.class.getDeclaredMethod("pose", new Class[0]);
                }
                PoseStack pose = (PoseStack)viaforge$pose.invoke((Object)graphics, new Object[0]);
                pose.pushPose();
                pose.scale(2.0f, 2.0f, 2.0f);
                graphics.drawCenteredString(this.font, String.valueOf(ChatFormatting.GOLD) + "ViaForge", this.width / 4, 3, 0xFFFFFF);
                pose.popPose();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        int n = this.width / 2;
        Objects.requireNonNull(this.font);
        graphics.drawCenteredString(this.font, "https://github.com/ViaVersion/ViaForge", n, (9 + 2) * 2 + 3, -1);
        GuiProtocolSelector.drawString(graphics, this.font, this.status != null ? this.status : "Discord: florianmichael");
    }

    public static interface FinishedCallback {
        public void finished(ProtocolVersion var1, Screen var2);
    }

    class SlotList
    extends ObjectSelectionList<SlotEntry> {
        public SlotList(Minecraft client, int width, int height, int top, int bottom, int slotHeight) {
            super(client, width, height - top - bottom, top, slotHeight);
            for (ProtocolVersion version : ProtocolVersionList.getProtocolsNewToOld()) {
                this.addEntry((AbstractSelectionList.Entry)new SlotEntry(version));
            }
        }

        public class SlotEntry
        extends ObjectSelectionList.Entry<SlotEntry> {
            private final ProtocolVersion ProtocolVersion;

            public SlotEntry(ProtocolVersion ProtocolVersion2) {
                this.ProtocolVersion = ProtocolVersion2;
            }

            public boolean mouseClicked(MouseButtonEvent p_429480_, boolean p_425718_) {
                GuiProtocolSelector.this.finishedCallback.finished(this.ProtocolVersion, GuiProtocolSelector.this.parent);
                return super.mouseClicked(p_429480_, p_425718_);
            }

            public Component getNarration() {
                return Component.literal((String)this.ProtocolVersion.getName());
            }

            public void renderContent(GuiGraphics guiGraphics, int i, int i1, boolean b, float v) {
                ProtocolVersion targetVersion = ViaForgeCommon.getManager().getTargetVersion();
                String color = targetVersion == this.ProtocolVersion ? (GuiProtocolSelector.this.simple ? ChatFormatting.GOLD.toString() : ChatFormatting.GREEN.toString()) : (GuiProtocolSelector.this.simple ? ChatFormatting.WHITE.toString() : ChatFormatting.DARK_RED.toString());
                guiGraphics.drawCenteredString(Minecraft.getInstance().font, color + this.ProtocolVersion.getName(), this.getContentXMiddle(), this.getContentY(), -1);
            }
        }
    }
}

