/*
 * Decompiled with CFR 0.152.
 */
package de.florianmichael.viaforge.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.viaversion.vialoader.util.ProtocolVersionList;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.util.DumpUtil;
import de.florianmichael.viaforge.common.ViaForgeCommon;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class GuiProtocolSelector
extends Screen {
    public final Screen parent;
    public final boolean simple;
    public final FinishedCallback finishedCallback;
    private SlotList list;
    private String status;
    private long time;

    public static void open(Minecraft minecraft) {
        minecraft.m_91152_((Screen)new GuiProtocolSelector(minecraft.f_91080_));
    }

    public GuiProtocolSelector(Screen parent) {
        this(parent, false, (version, unused) -> ViaForgeCommon.getManager().setTargetVersion(version));
    }

    public GuiProtocolSelector(Screen parent, boolean simple, FinishedCallback finishedCallback) {
        super((Component)new TextComponent("ViaForge Protocol Selector"));
        this.parent = parent;
        this.simple = simple;
        this.finishedCallback = finishedCallback;
    }

    public void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new Button(5, this.f_96544_ - 25, 20, 20, (Component)new TextComponent("<-"), b -> this.f_96541_.m_91152_(this.parent)));
        if (!this.simple) {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 105, 5, 100, 20, (Component)new TextComponent("Create dump"), b -> {
                try {
                    this.f_96541_.f_91068_.m_90911_(DumpUtil.postDump(UUID.randomUUID()).get());
                    this.setStatus(String.valueOf(ChatFormatting.GREEN) + "Dump created and copied to clipboard");
                }
                catch (InterruptedException | ExecutionException e) {
                    this.setStatus(String.valueOf(ChatFormatting.RED) + "Failed to create dump: " + e.getMessage());
                }
            }));
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 105, this.f_96544_ - 25, 100, 20, (Component)new TextComponent("Reload configs"), b -> Via.getManager().getConfigurationProvider().reloadConfigs()));
        }
        Objects.requireNonNull(this.f_96547_);
        Objects.requireNonNull(this.f_96547_);
        this.list = new SlotList(this.f_96541_, this.f_96543_, this.f_96544_, 6 + (9 + 2) * 3, this.f_96544_ - 30, 9 + 2);
        this.m_7787_((GuiEventListener)this.list);
    }

    public void setStatus(String status) {
        this.status = status;
        this.time = System.currentTimeMillis();
    }

    public boolean m_7933_(int keyCode, int scanCode, int actions) {
        if (keyCode == 256) {
            this.f_96541_.m_91152_(this.parent);
        }
        return super.m_7933_(keyCode, scanCode, actions);
    }

    public void m_6305_(PoseStack matrices, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        if (System.currentTimeMillis() - this.time >= 10000L) {
            this.status = null;
        }
        this.m_7333_(matrices);
        this.list.m_6305_(matrices, p_230430_2_, p_230430_3_, p_230430_4_);
        super.m_6305_(matrices, p_230430_2_, p_230430_3_, p_230430_4_);
        matrices.m_85836_();
        matrices.m_85841_(2.0f, 2.0f, 2.0f);
        GuiProtocolSelector.m_93208_((PoseStack)matrices, (Font)this.f_96547_, (String)(String.valueOf(ChatFormatting.GOLD) + "ViaForge"), (int)(this.f_96543_ / 4), (int)3, (int)0xFFFFFF);
        matrices.m_85849_();
        int n = this.f_96543_ / 2;
        Objects.requireNonNull(this.f_96547_);
        GuiProtocolSelector.m_93208_((PoseStack)matrices, (Font)this.f_96547_, (String)"https://github.com/ViaVersion/ViaForge", (int)n, (int)((9 + 2) * 2 + 3), (int)-1);
        GuiProtocolSelector.m_93236_((PoseStack)matrices, (Font)this.f_96547_, (String)(this.status != null ? this.status : "Discord: florianmichael"), (int)3, (int)3, (int)-1);
    }

    public static interface FinishedCallback {
        public void finished(ProtocolVersion var1, Screen var2);
    }

    class SlotList
    extends ObjectSelectionList<SlotEntry> {
        public SlotList(Minecraft client, int width, int height, int top, int bottom, int slotHeight) {
            super(client, width, height, top, bottom, slotHeight);
            for (ProtocolVersion version : ProtocolVersionList.getProtocolsNewToOld()) {
                this.m_7085_((AbstractSelectionList.Entry)new SlotEntry(version));
            }
        }

        public class SlotEntry
        extends ObjectSelectionList.Entry<SlotEntry> {
            private final ProtocolVersion ProtocolVersion;

            public SlotEntry(ProtocolVersion ProtocolVersion2) {
                this.ProtocolVersion = ProtocolVersion2;
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                GuiProtocolSelector.this.finishedCallback.finished(this.ProtocolVersion, GuiProtocolSelector.this.parent);
                return super.m_6375_(mouseX, mouseY, button);
            }

            public Component m_142172_() {
                return new TextComponent(this.ProtocolVersion.getName());
            }

            public void m_6311_(PoseStack matrices, int p_93524_, int y, int p_93526_, int p_93527_, int p_93528_, int p_93529_, int p_93530_, boolean p_93531_, float p_93532_) {
                ProtocolVersion targetVersion = ViaForgeCommon.getManager().getTargetVersion();
                String color = targetVersion == this.ProtocolVersion ? (GuiProtocolSelector.this.simple ? ChatFormatting.GOLD.toString() : ChatFormatting.GREEN.toString()) : (GuiProtocolSelector.this.simple ? ChatFormatting.WHITE.toString() : ChatFormatting.DARK_RED.toString());
                GuiComponent.m_93208_((PoseStack)matrices, (Font)Minecraft.m_91087_().f_91062_, (String)(color + this.ProtocolVersion.getName()), (int)(SlotList.this.f_93388_ / 2), (int)y, (int)-1);
            }
        }
    }
}

