/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaaprilfools.api.data;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaaprilfools.ViaAprilFools;
import com.viaversion.viaversion.api.data.MappingDataLoader;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class VAFMappingDataLoader
extends MappingDataLoader {
    static final Map<String, String[]> GLOBAL_IDENTIFIER_INDEXES = new HashMap<String, String[]>();
    public static final VAFMappingDataLoader INSTANCE = new VAFMappingDataLoader();

    public VAFMappingDataLoader() {
        super(VAFMappingDataLoader.class, "assets/viaaprilfools/data/");
    }

    public static void loadGlobalIdentifiers() {
        CompoundTag globalIdentifiers = INSTANCE.loadNBT("identifier-table.nbt");
        for (Map.Entry<String, Tag> entry : globalIdentifiers.entrySet()) {
            ListTag value = (ListTag)entry.getValue();
            String[] array = new String[value.size()];
            int size = value.size();
            for (int i = 0; i < size; ++i) {
                array[i] = ((StringTag)value.get(i)).getValue();
            }
            GLOBAL_IDENTIFIER_INDEXES.put(entry.getKey(), array);
        }
    }

    @Override
    public String identifierFromGlobalId(String registry, int globalId) {
        String[] array = GLOBAL_IDENTIFIER_INDEXES.get(registry);
        if (array == null) {
            throw new IllegalArgumentException("Unknown global identifier key: " + registry);
        }
        if (globalId < 0 || globalId >= array.length) {
            throw new IllegalArgumentException("Unknown global identifier index: " + globalId);
        }
        return array[globalId];
    }

    @Override
    public File getDataFolder() {
        return ViaAprilFools.getPlatform().getDataFolder();
    }

    @Override
    public Logger getLogger() {
        return ViaAprilFools.getPlatform().getLogger();
    }
}

