/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.v1_16to1_15_2.storage;

import com.viaversion.viabackwards.protocol.v1_16to1_15_2.Protocol1_16To1_15_2;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.protocols.v1_14_4to1_15.packet.ClientboundPackets1_15;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class PlayerAttributesStorage
implements StorableObject {
    private final Map<String, Attribute> attributes = new HashMap<String, Attribute>();

    public void sendAttributes(UserConnection connection, int entityId) {
        PacketWrapper updateAttributes = PacketWrapper.create(ClientboundPackets1_15.UPDATE_ATTRIBUTES, connection);
        updateAttributes.write(Types.VAR_INT, entityId);
        updateAttributes.write(Types.INT, this.attributes.size());
        for (Map.Entry<String, Attribute> attributeEntry : this.attributes.entrySet()) {
            Attribute attribute = attributeEntry.getValue();
            updateAttributes.write(Types.STRING, attributeEntry.getKey());
            updateAttributes.write(Types.DOUBLE, attribute.value());
            updateAttributes.write(Types.VAR_INT, attribute.modifiers().length);
            for (AttributeModifier modifier : attribute.modifiers()) {
                updateAttributes.write(Types.UUID, modifier.uuid());
                updateAttributes.write(Types.DOUBLE, modifier.amount());
                updateAttributes.write(Types.BYTE, modifier.operation());
            }
        }
        updateAttributes.send(Protocol1_16To1_15_2.class);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }

    public void addAttribute(String key, Attribute attribute) {
        this.attributes.put(key, attribute);
    }

    public record Attribute(double value, AttributeModifier[] modifiers) {
    }

    public record AttributeModifier(UUID uuid, double amount, byte operation) {
    }
}

