/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.protocols.v1_17_1to1_18.storage;

import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.minecraft.ChunkPosition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ChunkLightStorage
implements StorableObject {
    private final Map<Long, ChunkLight> lightPackets = new HashMap<Long, ChunkLight>();
    private final Set<Long> loadedChunks = new HashSet<Long>();

    public void storeLight(int x, int z, ChunkLight chunkLight) {
        this.lightPackets.put(ChunkPosition.chunkKey(x, z), chunkLight);
    }

    public @Nullable ChunkLight removeLight(int x, int z) {
        return this.lightPackets.remove(ChunkPosition.chunkKey(x, z));
    }

    public @Nullable ChunkLight getLight(int x, int z) {
        return this.lightPackets.get(ChunkPosition.chunkKey(x, z));
    }

    public boolean addLoadedChunk(int x, int z) {
        return this.loadedChunks.add(ChunkPosition.chunkKey(x, z));
    }

    public boolean isLoaded(int x, int z) {
        return this.loadedChunks.contains(ChunkPosition.chunkKey(x, z));
    }

    public void clear(int x, int z) {
        long index = ChunkPosition.chunkKey(x, z);
        this.lightPackets.remove(index);
        this.loadedChunks.remove(index);
    }

    public void clear() {
        this.loadedChunks.clear();
        this.lightPackets.clear();
    }

    public record ChunkLight(boolean trustEdges, long[] skyLightMask, long[] blockLightMask, long[] emptySkyLightMask, long[] emptyBlockLightMask, byte[][] skyLight, byte[][] blockLight) {
    }
}

