/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.api.remapper;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.item.HashedItem;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.rewriter.ItemRewriter;
import com.viaversion.viaversion.api.rewriter.RewriterBase;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectArrayList;
import com.viaversion.viaversion.libs.fastutil.objects.ObjectList;
import java.util.Arrays;
import java.util.Objects;
import viaforge-mc1165.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@NestMembers(value={NonExistentEntry.class, RewriteEntry.class, 1.class})
public abstract class LegacyItemRewriter<C extends ClientboundPacketType, S extends ServerboundPacketType, P extends Protocol<C, ?, ?, S>>
extends RewriterBase<P>
implements ItemRewriter<P> {
    private final ObjectList<RewriteEntry> rewriteEntries = new ObjectArrayList<RewriteEntry>();
    private final ObjectList<NonExistentEntry> nonExistentItems = new ObjectArrayList<NonExistentEntry>();
    protected final String protocolName;
    private final Type<Item> itemType;
    private final Type<Item> mappedItemType;
    private final Type<Item[]> itemArrayType;
    private final Type<Item[]> mappedItemArrayType;

    public LegacyItemRewriter(P protocol, String protocolName, Type<Item> itemType, Type<Item[]> itemArrayType) {
        this(protocol, protocolName, itemType, itemArrayType, itemType, itemArrayType);
    }

    public LegacyItemRewriter(P protocol, String protocolName, Type<Item> itemType, Type<Item[]> itemArrayType, Type<Item> mappedItemType, Type<Item[]> mappedItemArrayType) {
        super(protocol);
        this.protocolName = protocolName;
        this.itemType = itemType;
        this.itemArrayType = itemArrayType;
        this.mappedItemType = mappedItemType;
        this.mappedItemArrayType = mappedItemArrayType;
    }

    protected void addRemappedItem(int oldItemId, int newItemId, String newItemName) {
        this.addRemappedItem(oldItemId, newItemId, -1, newItemName);
    }

    protected void addRemappedItem(int oldItemId, int newItemId, int newItemMeta, String newItemName) {
        this.addRemappedItem(oldItemId, -1, newItemId, newItemMeta, newItemName);
    }

    protected void addRemappedItem(int oldItemId, int oldItemMeta, int newItemId, int newItemMeta, String newItemName) {
        this.rewriteEntries.add(new RewriteEntry(oldItemId, (short)oldItemMeta, newItemId, (short)newItemMeta, newItemName));
    }

    protected void addNonExistentItem(int itemId, int itemMeta) {
        this.nonExistentItems.add(new NonExistentEntry(itemId, (short)itemMeta));
    }

    protected void addNonExistentItem(int itemId, int startItemMeta, int endItemMeta) {
        for (int i = startItemMeta; i <= endItemMeta; ++i) {
            this.nonExistentItems.add(new NonExistentEntry(itemId, (short)i));
        }
    }

    protected void addNonExistentItems(int ... itemIds) {
        for (int itemId : itemIds) {
            this.nonExistentItems.add(new NonExistentEntry(itemId, -1));
        }
    }

    protected void addNonExistentItemRange(int startItemId, int endItemId) {
        for (int i = startItemId; i <= endItemId; ++i) {
            this.nonExistentItems.add(new NonExistentEntry(i, -1));
        }
    }

    public void registerCreativeInventoryAction(S packetType) {
        this.protocol.registerServerbound(packetType, new PacketHandlers(){

            @Override
            public void register() {
                this.map(Types.SHORT);
                this.handler(wrapper -> LegacyItemRewriter.this.jvmdowngrader$nest$net_raphimc_vialegacy_api_remapper_LegacyItemRewriter$handleServerboundItem(wrapper));
            }
        });
    }

    @Override
    public Item handleItemToClient(UserConnection user, Item item) {
        if (item == null) {
            return null;
        }
        for (RewriteEntry rewriteEntry : this.rewriteEntries) {
            if (!rewriteEntry.rewrites(item)) continue;
            this.setRemappedNameRead(item, rewriteEntry.jvmdowngrader$nest$net_raphimc_vialegacy_api_remapper_LegacyItemRewriter$RewriteEntry$get$newItemName());
            if (rewriteEntry.jvmdowngrader$nest$net_raphimc_vialegacy_api_remapper_LegacyItemRewriter$RewriteEntry$get$newItemMeta() != -1) {
                item.setData(rewriteEntry.jvmdowngrader$nest$net_raphimc_vialegacy_api_remapper_LegacyItemRewriter$RewriteEntry$get$newItemMeta());
            }
            item.setIdentifier(rewriteEntry.jvmdowngrader$nest$net_raphimc_vialegacy_api_remapper_LegacyItemRewriter$RewriteEntry$get$newItemID());
        }
        return item;
    }

    @Override
    public Item handleItemToServer(UserConnection user, Item item) {
        if (item == null) {
            return null;
        }
        for (NonExistentEntry nonExistentEntry : this.nonExistentItems) {
            if (!nonExistentEntry.rewrites(item)) continue;
            item.setIdentifier(1);
            item.setData((short)0);
            return item;
        }
        this.setRemappedTagWrite(item);
        return item;
    }

    @Override
    public HashedItem handleHashedItem(UserConnection connection, HashedItem item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Type<Item> itemType() {
        return this.itemType;
    }

    @Override
    public Type<Item[]> itemArrayType() {
        return this.itemArrayType;
    }

    @Override
    public Type<Item> mappedItemType() {
        return this.mappedItemType;
    }

    @Override
    public Type<Item[]> mappedItemArrayType() {
        return this.mappedItemArrayType;
    }

    @Override
    public String nbtTagName() {
        return LegacyItemRewriter.jvmdowngrader$concat$nbtTagName$1(this.protocol.getClass().getSimpleName());
    }

    private void handleClientboundItem(PacketWrapper wrapper) {
        Item item = this.handleItemToClient(wrapper.user(), wrapper.read(this.itemType));
        wrapper.write(this.mappedItemType, item);
    }

    private void handleServerboundItem(PacketWrapper wrapper) {
        Item item = this.handleItemToServer(wrapper.user(), wrapper.read(this.mappedItemType));
        wrapper.write(this.itemType, item);
    }

    private void setRemappedNameRead(Item item, String name) {
        CompoundTag viaLegacyTag = new CompoundTag();
        viaLegacyTag.putInt("Id", item.identifier());
        viaLegacyTag.putShort("Meta", item.data());
        CompoundTag tag = item.tag();
        if (tag == null) {
            tag = new CompoundTag();
            item.setTag(tag);
            viaLegacyTag.putBoolean("RemoveTag", true);
        }
        tag.put(this.nbtTagName(), viaLegacyTag);
        CompoundTag display = tag.getCompoundTag("display");
        if (display == null) {
            display = new CompoundTag();
            tag.put("display", display);
            viaLegacyTag.putBoolean("RemoveDisplayTag", true);
        }
        if (display.contains("Name")) {
            ListTag<StringTag> lore = display.getListTag("Lore", StringTag.class);
            if (lore == null) {
                lore = new ListTag<StringTag>(StringTag.class);
                display.put("Lore", lore);
                viaLegacyTag.putBoolean("RemoveLore", true);
            }
            lore.add(new StringTag(LegacyItemRewriter.jvmdowngrader$concat$setRemappedNameRead$1(this.protocolName, item.identifier(), name)));
            viaLegacyTag.putBoolean("RemoveLastLore", true);
        } else {
            display.putString("Name", LegacyItemRewriter.jvmdowngrader$concat$setRemappedNameRead$1(this.protocolName, name));
            viaLegacyTag.putBoolean("RemoveDisplayName", true);
        }
    }

    private void setRemappedTagWrite(Item item) {
        CompoundTag tag = item.tag();
        if (tag == null) {
            return;
        }
        CompoundTag viaLegacyTag = (CompoundTag)tag.removeUnchecked(this.nbtTagName());
        if (viaLegacyTag == null) {
            return;
        }
        item.setIdentifier(viaLegacyTag.getNumberTag("Id").asInt());
        item.setData(viaLegacyTag.getNumberTag("Meta").asShort());
        if (viaLegacyTag.contains("RemoveLastLore")) {
            ListTag<StringTag> lore = tag.getCompoundTag("display").getListTag("Lore", StringTag.class);
            lore.remove(lore.size() - 1);
        }
        if (viaLegacyTag.contains("RemoveLore")) {
            tag.getCompoundTag("display").remove("Lore");
        }
        if (viaLegacyTag.contains("RemoveDisplayName")) {
            tag.getCompoundTag("display").remove("Name");
        }
        if (viaLegacyTag.contains("RemoveDisplayTag")) {
            tag.remove("display");
        }
        if (viaLegacyTag.contains("RemoveTag")) {
            item.setTag(null);
        }
    }

    public /* synthetic */ void jvmdowngrader$nest$net_raphimc_vialegacy_api_remapper_LegacyItemRewriter$handleServerboundItem(PacketWrapper packetWrapper) {
        this.handleServerboundItem(packetWrapper);
    }

    private static /* synthetic */ String jvmdowngrader$concat$nbtTagName$1(String string) {
        return "VL|" + string;
    }

    private static /* synthetic */ String jvmdowngrader$concat$setRemappedNameRead$1(String string, int n, String string2) {
        return "\u00a7r " + string + " Item ID: " + n + " (" + string2 + ")";
    }

    private static /* synthetic */ String jvmdowngrader$concat$setRemappedNameRead$1(String string, String string2) {
        return "\u00a7r" + string + " " + string2;
    }

    @RecordComponents(value={@RecordComponents.Value(name="oldItemID", type=int.class), @RecordComponents.Value(name="oldItemMeta", type=short.class), @RecordComponents.Value(name="newItemID", type=int.class), @RecordComponents.Value(name="newItemMeta", type=short.class), @RecordComponents.Value(name="newItemName", type=String.class)})
    @NestHost(value=LegacyItemRewriter.class)
    private static final class RewriteEntry
    extends J_L_Record {
        private final int oldItemID;
        private final short oldItemMeta;
        private final int newItemID;
        private final short newItemMeta;
        private final String newItemName;

        RewriteEntry(int oldItemID, short oldItemMeta, int newItemID, short newItemMeta, String newItemName) {
            this.oldItemID = oldItemID;
            this.oldItemMeta = oldItemMeta;
            this.newItemID = newItemID;
            this.newItemMeta = newItemMeta;
            this.newItemName = newItemName;
        }

        public boolean rewrites(Item item) {
            return item.identifier() == this.oldItemID && (this.oldItemMeta == -1 || this.oldItemMeta == item.data());
        }

        @Override
        public final String toString() {
            return RewriteEntry.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return RewriteEntry.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return RewriteEntry.jvmdowngrader$equals$equals(this, o);
        }

        public int oldItemID() {
            return this.oldItemID;
        }

        public short oldItemMeta() {
            return this.oldItemMeta;
        }

        public int newItemID() {
            return this.newItemID;
        }

        public short newItemMeta() {
            return this.newItemMeta;
        }

        public String newItemName() {
            return this.newItemName;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(RewriteEntry rewriteEntry) {
            RewriteEntry rewriteEntry2 = rewriteEntry;
            return "LegacyItemRewriter$RewriteEntry[" + "oldItemID=" + rewriteEntry.oldItemID + ", " + "oldItemMeta=" + rewriteEntry.oldItemMeta + ", " + "newItemID=" + rewriteEntry.newItemID + ", " + "newItemMeta=" + rewriteEntry.newItemMeta + ", " + "newItemName=" + rewriteEntry.newItemName + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(RewriteEntry rewriteEntry) {
            Object[] objectArray = new Object[]{rewriteEntry.oldItemID, rewriteEntry.oldItemMeta, rewriteEntry.newItemID, rewriteEntry.newItemMeta, rewriteEntry.newItemName};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(RewriteEntry rewriteEntry, Object object) {
            if (rewriteEntry == object) {
                return true;
            }
            if (object != null && object instanceof RewriteEntry) {
                RewriteEntry rewriteEntry2 = (RewriteEntry)object;
                if (rewriteEntry.oldItemID == rewriteEntry2.oldItemID && rewriteEntry.oldItemMeta == rewriteEntry2.oldItemMeta && rewriteEntry.newItemID == rewriteEntry2.newItemID && rewriteEntry.newItemMeta == rewriteEntry2.newItemMeta && Objects.equals(rewriteEntry.newItemName, rewriteEntry2.newItemName)) {
                    return true;
                }
            }
            return false;
        }

        public /* synthetic */ int jvmdowngrader$nest$net_raphimc_vialegacy_api_remapper_LegacyItemRewriter$RewriteEntry$get$newItemID() {
            return this.newItemID;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_raphimc_vialegacy_api_remapper_LegacyItemRewriter$RewriteEntry$set$newItemID(int n) {
            this.newItemID = n;
        }

        public /* synthetic */ String jvmdowngrader$nest$net_raphimc_vialegacy_api_remapper_LegacyItemRewriter$RewriteEntry$get$newItemName() {
            return this.newItemName;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_raphimc_vialegacy_api_remapper_LegacyItemRewriter$RewriteEntry$set$newItemName(String string) {
            this.newItemName = string;
        }

        public /* synthetic */ short jvmdowngrader$nest$net_raphimc_vialegacy_api_remapper_LegacyItemRewriter$RewriteEntry$get$newItemMeta() {
            return this.newItemMeta;
        }

        public /* synthetic */ void jvmdowngrader$nest$net_raphimc_vialegacy_api_remapper_LegacyItemRewriter$RewriteEntry$set$newItemMeta(short s) {
            this.newItemMeta = s;
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="itemId", type=int.class), @RecordComponents.Value(name="itemMeta", type=short.class)})
    @NestHost(value=LegacyItemRewriter.class)
    private static final class NonExistentEntry
    extends J_L_Record {
        private final int itemId;
        private final short itemMeta;

        NonExistentEntry(int itemId, short itemMeta) {
            this.itemId = itemId;
            this.itemMeta = itemMeta;
        }

        public boolean rewrites(Item item) {
            return item.identifier() == this.itemId && (this.itemMeta == -1 || this.itemMeta == item.data());
        }

        @Override
        public final String toString() {
            return NonExistentEntry.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return NonExistentEntry.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return NonExistentEntry.jvmdowngrader$equals$equals(this, o);
        }

        public int itemId() {
            return this.itemId;
        }

        public short itemMeta() {
            return this.itemMeta;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(NonExistentEntry nonExistentEntry) {
            NonExistentEntry nonExistentEntry2 = nonExistentEntry;
            return "LegacyItemRewriter$NonExistentEntry[" + "itemId=" + nonExistentEntry.itemId + ", " + "itemMeta=" + nonExistentEntry.itemMeta + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(NonExistentEntry nonExistentEntry) {
            Object[] objectArray = new Object[]{nonExistentEntry.itemId, nonExistentEntry.itemMeta};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(NonExistentEntry nonExistentEntry, Object object) {
            if (nonExistentEntry == object) {
                return true;
            }
            if (object != null && object instanceof NonExistentEntry) {
                NonExistentEntry nonExistentEntry2 = (NonExistentEntry)object;
                if (nonExistentEntry.itemId == nonExistentEntry2.itemId && nonExistentEntry.itemMeta == nonExistentEntry2.itemMeta) {
                    return true;
                }
            }
            return false;
        }
    }
}

