/*
 * Decompiled with CFR 0.152.
 */
package me.juancarloscp52.spyglass_improvements.client;

import me.juancarloscp52.spyglass_improvements.client.Settings;
import me.juancarloscp52.spyglass_improvements.client.SpyglassImprovementsClient;
import me.juancarloscp52.spyglass_improvements.client.SpyglassSliderWidget;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class SpyglassConfigurationScreen
extends Screen {
    private static final Component TITLE = Component.translatable((String)"options.spyglass-improvements.title");
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this, 50, 60);
    private final Screen lastScreen;
    Settings settings;

    public SpyglassConfigurationScreen(Screen parent) {
        super(TITLE);
        this.settings = SpyglassImprovementsClient.getInstance().settings;
        this.lastScreen = parent;
    }

    protected void init() {
        LinearLayout linearLayout = (LinearLayout)this.layout.addToHeader((LayoutElement)LinearLayout.vertical().spacing(8));
        linearLayout.addChild((LayoutElement)new StringWidget(TITLE, this.font), LayoutSettings::alignHorizontallyCenter);
        linearLayout.addChild((LayoutElement)new SpyglassSliderWidget(0, 0, 300, 20, "options.spyglass-improvements.zoomQuantity", (this.settings.multiplierDelta - 0.1f) * 1.25f, (slider, translationKey, value) -> Component.translatable((String)"options.spyglass-improvements.zoomQuantity", (Object[])new Object[]{String.format("%.2f", Float.valueOf(0.1f + (float)value * 0.8f))}), value -> {
            this.settings.multiplierDelta = 0.1f + (float)value * 0.8f;
        }));
        GridLayout gridLayout = new GridLayout();
        gridLayout.defaultCellSetting().padding(4, 4, 4, 0);
        GridLayout.RowHelper rowHelper = gridLayout.createRowHelper(2);
        rowHelper.addChild((LayoutElement)this.getExtraZoomButton());
        rowHelper.addChild((LayoutElement)this.getSpyglassOverlayButton());
        rowHelper.addChild((LayoutElement)this.getShowCrosshairButton());
        rowHelper.addChild((LayoutElement)this.getSmoothCameraButton());
        rowHelper.addChild((LayoutElement)this.getForceSpyglassButton());
        rowHelper.addChild((LayoutElement)this.getHideSettingsButton());
        this.layout.addToContents((LayoutElement)gridLayout);
        LinearLayout linearLayoutFooter = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.vertical().spacing(2));
        linearLayoutFooter.addChild((LayoutElement)this.getResetButton());
        linearLayoutFooter.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, buttonx -> this.onDone()).width(200).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.layout.arrangeElements();
    }

    private Button getSpyglassOverlayButton() {
        return Button.builder((Component)Component.translatable((String)"options.spyglass-improvements.spyglassOverlay", (Object[])new Object[]{I18n.get((String)("options.spyglass-improvements.spyglassOverlay." + this.settings.overlay), (Object[])new Object[0])}), button -> {
            this.settings.overlay = (short)(this.settings.overlay + 1);
            if (this.settings.overlay > 3) {
                this.settings.overlay = 0;
            }
            button.setMessage((Component)Component.translatable((String)"options.spyglass-improvements.spyglassOverlay", (Object[])new Object[]{I18n.get((String)("options.spyglass-improvements.spyglassOverlay." + this.settings.overlay), (Object[])new Object[0])}));
        }).build();
    }

    private Button getShowCrosshairButton() {
        return Button.builder((Component)Component.translatable((String)"options.spyglass-improvements.showCrosshair", (Object[])new Object[]{this.settings.showCrossHair ? CommonComponents.GUI_YES : CommonComponents.GUI_NO}), button -> {
            this.settings.showCrossHair = !this.settings.showCrossHair;
            button.setMessage((Component)Component.translatable((String)"options.spyglass-improvements.showCrosshair", (Object[])new Object[]{this.settings.showCrossHair ? CommonComponents.GUI_YES : CommonComponents.GUI_NO}));
        }).build();
    }

    private Button getSmoothCameraButton() {
        return Button.builder((Component)Component.translatable((String)"options.spyglass-improvements.smoothCamera", (Object[])new Object[]{this.settings.smoothCamera ? CommonComponents.GUI_YES : CommonComponents.GUI_NO}), button -> {
            this.settings.smoothCamera = !this.settings.smoothCamera;
            button.setMessage((Component)Component.translatable((String)"options.spyglass-improvements.smoothCamera", (Object[])new Object[]{this.settings.smoothCamera ? CommonComponents.GUI_YES : CommonComponents.GUI_NO}));
        }).build();
    }

    private Button getHideSettingsButton() {
        return Button.builder((Component)Component.translatable((String)"options.spyglass-improvements.hideSettingsButton", (Object[])new Object[]{this.settings.hideSettingsButton ? CommonComponents.GUI_YES : CommonComponents.GUI_NO}), button -> {
            this.settings.hideSettingsButton = !this.settings.hideSettingsButton;
            button.setMessage((Component)Component.translatable((String)"options.spyglass-improvements.hideSettingsButton", (Object[])new Object[]{this.settings.hideSettingsButton ? CommonComponents.GUI_YES : CommonComponents.GUI_NO}));
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"options.spyglass-improvements.hideSettingsButton.tooltip"))).build();
    }

    private Button getExtraZoomButton() {
        return Button.builder((Component)Component.translatable((String)"options.spyglass-improvements.extraZoom", (Object[])new Object[]{this.settings.extraZoom ? CommonComponents.GUI_YES : CommonComponents.GUI_NO}), button -> {
            this.settings.extraZoom = !this.settings.extraZoom;
            button.setMessage((Component)Component.translatable((String)"options.spyglass-improvements.extraZoom", (Object[])new Object[]{this.settings.extraZoom ? CommonComponents.GUI_YES : CommonComponents.GUI_NO}));
        }).build();
    }

    private Button getForceSpyglassButton() {
        return Button.builder((Component)Component.translatable((String)"options.spyglass-improvements.forceSpyglass", (Object[])new Object[]{this.settings.userForceSpyglass ? CommonComponents.GUI_YES : CommonComponents.GUI_NO}), button -> {
            this.settings.userForceSpyglass = !this.settings.userForceSpyglass;
            button.setMessage((Component)Component.translatable((String)"options.spyglass-improvements.forceSpyglass", (Object[])new Object[]{this.settings.userForceSpyglass ? CommonComponents.GUI_YES : CommonComponents.GUI_NO}));
        }).tooltip(Tooltip.create((Component)Component.translatable((String)"options.spyglass-improvements.forceSpyglass.tooltip"))).build();
    }

    private Button getResetButton() {
        return Button.builder((Component)Component.translatable((String)"options.spyglass-improvements.reset"), button -> {
            SpyglassImprovementsClient.getInstance().settings = new Settings();
            this.onDone();
        }).width(200).build();
    }

    private void onDone() {
        SpyglassImprovementsClient.getInstance().saveSettings();
        this.onClose();
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }
}

