/*
 * Decompiled with CFR 0.152.
 */
package me.juancarloscp52.spyglass_improvements.client;

import com.google.gson.Gson;
import com.mojang.blaze3d.platform.InputConstants;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import me.juancarloscp52.spyglass_improvements.client.Settings;
import me.juancarloscp52.spyglass_improvements.client.integrations.IEquipmentIntegration;
import me.juancarloscp52.spyglass_improvements.mixin.MinecraftClientInvoker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpyglassImprovementsClient {
    public static final String MOD_ID = "spyglass_improvements";
    private static SpyglassImprovementsClient INSTANCE;
    public static final Logger LOGGER;
    public Settings settings;
    private IEquipmentIntegration equipmentIntegration;
    public static boolean force_spyglass;
    public static int slot;
    public static float MULTIPLIER;
    public static final KeyMapping.Category SPYGLASS_IMPROVEMENTS;
    public static KeyMapping useSpyglass;

    public static SpyglassImprovementsClient getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SpyglassImprovementsClient();
        }
        return INSTANCE;
    }

    public void init(IEquipmentIntegration equipmentIntegration) {
        INSTANCE = this;
        this.equipmentIntegration = equipmentIntegration;
        this.loadSettings();
        LOGGER.info("Spyglass Improvements Client Initialized");
    }

    public void onClientTick(Minecraft client) {
        if (client.player == null || client.gameMode == null) {
            return;
        }
        LocalPlayer player = client.player;
        if (useSpyglass.isDown() && ((MinecraftClientInvoker)client).getItemUseCooldown() == 0 && !client.player.isUsingItem()) {
            slot = this.findSlotByItem(client.player.getInventory(), Items.SPYGLASS);
            if (player.getOffhandItem().getItem().equals(Items.SPYGLASS)) {
                client.gameMode.useItem((Player)player, InteractionHand.OFF_HAND);
            } else if (player.getMainHandItem().getItem().equals(Items.SPYGLASS)) {
                client.gameMode.useItem((Player)player, InteractionHand.MAIN_HAND);
            } else if (player.isCreative()) {
                this.forceUseSpyglass(player);
            } else if (this.equipmentIntegration != null && this.equipmentIntegration.isPlayerUsingSpyglass((Player)player)) {
                this.forceUseSpyglass(player);
            } else if (slot >= 9) {
                client.gameMode.handleInventoryMouseClick(0, slot, 40, ClickType.SWAP, (Player)player);
                client.gameMode.useItem((Player)player, InteractionHand.OFF_HAND);
            } else if (slot >= 0) {
                int oldSlot = player.getInventory().getSelectedSlot();
                player.getInventory().setSelectedSlot(slot);
                slot = oldSlot;
                client.gameMode.useItem((Player)player, InteractionHand.MAIN_HAND);
            }
        } else if (!useSpyglass.isDown() && force_spyglass) {
            force_spyglass = false;
            player.playSound(SoundEvents.SPYGLASS_STOP_USING, 1.0f, 1.0f);
        }
    }

    private int findSlotByItem(Inventory inventory, Item item) {
        NonNullList items = inventory.getNonEquipmentItems();
        for (int i = 0; i < items.size(); ++i) {
            if (((ItemStack)items.get(i)).isEmpty() || !((ItemStack)items.get(i)).is(item)) continue;
            return i;
        }
        return -1;
    }

    private void forceUseSpyglass(LocalPlayer player) {
        if (force_spyglass) {
            return;
        }
        force_spyglass = true;
        player.playSound(SoundEvents.SPYGLASS_USE, 1.0f, 1.0f);
    }

    public void loadSettings() {
        File file = new File("./config/spyglass-improvements/settings.json");
        Gson gson = new Gson();
        if (file.exists()) {
            try {
                FileReader fileReader = new FileReader(file);
                this.settings = (Settings)gson.fromJson((Reader)fileReader, Settings.class);
                fileReader.close();
            }
            catch (IOException e) {
                LOGGER.warn("Could not load Spyglass Improvements settings: " + e.getLocalizedMessage());
            }
        } else {
            this.settings = new Settings();
            this.saveSettings();
        }
    }

    public void saveSettings() {
        Gson gson = new Gson();
        File file = new File("./config/spyglass-improvements/settings.json");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson((Object)this.settings));
            fileWriter.close();
        }
        catch (IOException e) {
            LOGGER.warn("Could not save Spyglass Improvements settings: " + e.getLocalizedMessage());
        }
    }

    static {
        LOGGER = LogManager.getLogger();
        force_spyglass = false;
        slot = -1;
        MULTIPLIER = 0.1f;
        SPYGLASS_IMPROVEMENTS = KeyMapping.Category.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"spyglass-improvements", (String)"spyglass"));
        useSpyglass = new KeyMapping("key.spyglass-improvements.use", InputConstants.Type.KEYSYM, 90, SPYGLASS_IMPROVEMENTS);
    }
}

