/*
 * Decompiled with CFR 0.152.
 */
package me.juancarloscp52.spyglass_improvements.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.platform.InputConstants;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import me.juancarloscp52.spyglass_improvements.client.Settings;
import me.juancarloscp52.spyglass_improvements.client.integrations.IEquipmentIntegration;
import me.juancarloscp52.spyglass_improvements.mixin.MinecraftClientInvoker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpyglassImprovementsClient {
    public static final String MOD_ID = "spyglass_improvements";
    private static SpyglassImprovementsClient INSTANCE;
    public static final Logger LOGGER;
    public Settings settings;
    private IEquipmentIntegration equipmentIntegration;
    public static boolean force_spyglass;
    public static int slot;
    public static float MULTIPLIER;
    public boolean forge = false;
    public static KeyMapping useSpyglass;

    public static SpyglassImprovementsClient getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SpyglassImprovementsClient();
        }
        return INSTANCE;
    }

    public void init(IEquipmentIntegration equipmentIntegration) {
        this.init(equipmentIntegration, false);
    }

    public void init(IEquipmentIntegration equipmentIntegration, boolean forge) {
        INSTANCE = this;
        this.equipmentIntegration = equipmentIntegration;
        this.forge = forge;
        this.loadSettings(forge);
        LOGGER.info("Spyglass Improvements Client Initialized");
    }

    public void onClientTick(Minecraft client) {
        if (client.f_91074_ == null || client.f_91072_ == null) {
            return;
        }
        LocalPlayer player = client.f_91074_;
        if (useSpyglass.m_90857_() && ((MinecraftClientInvoker)client).getItemUseCooldown() == 0 && !client.f_91074_.m_6117_()) {
            slot = this.findSlotByItem(client.f_91074_.m_150109_(), Items.f_151059_);
            if (player.m_21206_().m_41720_().equals(Items.f_151059_)) {
                client.f_91072_.m_105235_((Player)player, (Level)client.f_91073_, InteractionHand.OFF_HAND);
            } else if (player.m_21205_().m_41720_().equals(Items.f_151059_)) {
                client.f_91072_.m_105235_((Player)player, (Level)client.f_91073_, InteractionHand.MAIN_HAND);
            } else if (player.m_7500_() || this.settings.userForceSpyglass) {
                this.forceUseSpyglass(player);
            } else if (this.equipmentIntegration != null && this.equipmentIntegration.isPlayerUsingSpyglass((Player)player)) {
                this.forceUseSpyglass(player);
            } else if (slot >= 9) {
                client.f_91072_.m_171799_(0, slot, 40, ClickType.SWAP, (Player)player);
                client.f_91072_.m_105235_((Player)player, (Level)client.f_91073_, InteractionHand.OFF_HAND);
            } else if (slot >= 0) {
                int oldSlot = player.m_150109_().f_35977_;
                player.m_150109_().f_35977_ = slot;
                slot = oldSlot;
                client.f_91072_.m_105235_((Player)player, (Level)client.f_91073_, InteractionHand.MAIN_HAND);
            }
        } else if (!useSpyglass.m_90857_() && force_spyglass) {
            force_spyglass = false;
            player.m_5496_(SoundEvents.f_144232_, 1.0f, 1.0f);
        }
    }

    private int findSlotByItem(Inventory inventory, Item item) {
        NonNullList items = inventory.f_35974_;
        for (int i = 0; i < items.size(); ++i) {
            if (((ItemStack)items.get(i)).m_41619_() || !((ItemStack)items.get(i)).m_150930_(item)) continue;
            return i;
        }
        return -1;
    }

    private void forceUseSpyglass(LocalPlayer player) {
        if (force_spyglass) {
            return;
        }
        force_spyglass = true;
        player.m_5496_(SoundEvents.f_144231_, 1.0f, 1.0f);
    }

    public void loadSettings(boolean forge) {
        File file = new File("./config/spyglass-improvements/settings.json");
        Gson gson = new Gson();
        if (file.exists()) {
            try {
                FileReader fileReader = new FileReader(file);
                this.settings = (Settings)gson.fromJson((Reader)fileReader, Settings.class);
                fileReader.close();
            }
            catch (IOException e) {
                LOGGER.warn("Could not load Spyglass Improvements settings: " + e.getLocalizedMessage());
            }
        } else {
            this.settings = new Settings();
            if (forge) {
                this.settings.hideSettingsButton = true;
            }
            this.saveSettings();
        }
    }

    public void saveSettings() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File file = new File("./config/spyglass-improvements/settings.json");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson((Object)this.settings));
            fileWriter.close();
        }
        catch (IOException e) {
            LOGGER.warn("Could not save Spyglass Improvements settings: " + e.getLocalizedMessage());
        }
    }

    static {
        LOGGER = LogManager.getLogger();
        force_spyglass = false;
        slot = -1;
        MULTIPLIER = 0.1f;
        useSpyglass = new KeyMapping("key.spyglass-improvements.use", InputConstants.Type.KEYSYM, 90, "category.spyglass-improvements");
    }
}

