package org.tywrapstudios.ctd.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import org.tywrapstudios.ctd.CTDCommon;
import org.tywrapstudios.ctd.compat.Spark;
import org.tywrapstudios.ctd.config.CTDConfig;
import org.tywrapstudios.ctd.handlers.Handlers;
import org.tywrapstudios.ctd.platform.CTDServices;

import java.util.List;
import java.util.concurrent.TimeoutException;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class CTDCommand {
    public CTDCommand() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(class_2170.method_9247("ctd").requires((source) -> source.method_9259(2))
                .executes(CTDCommand::execute)
                .then(class_2170.method_9247("reload")
                        .executes(CTDCommand::reload))
                .then(class_2170.method_9247("debug")
                        .requires((source) -> source.method_9259(3))
                        .then(class_2170.method_9247("dump_config")
                                .executes(CTDCommand::dumpConfig))
                        .then(class_2170.method_9247("force_chat")
                                .executes(CTDCommand::forceChat))
                        .then(class_2170.method_9247("force_game")
                                .executes(CTDCommand::forceGameMessage))
                        .then(class_2170.method_9247("force_crash")
                                .executes(CTDCommand::forceCrashMessage))
                        .then(class_2170.method_9247("force_timeout")
                                .executes(CTDCommand::forceTimeoutMessage))
                )
        );
    }

    private static int forceTimeoutMessage(CommandContext<class_2168> context) {
        Spark.handleSparkWorldTimeOut(new TimeoutException("DEBUG TIMEOUT"));
        return 1;
    }

    private static int forceCrashMessage(CommandContext<class_2168> context) {
        Handlers.handleCrash("DEBUG CAUSE", null);
        return 1;
    }

    private static int forceGameMessage(CommandContext<class_2168> context) {
        Handlers.handleGameMessage("Debug message");
        return 1;
    }

    private static int forceChat(CommandContext<class_2168> context) {
        try {
            Handlers.handleChatMessage("Debug message", context.getSource().method_44023().method_5845(), context.getSource().method_44023().method_5477().getString());
        } catch (NullPointerException e) {
            Handlers.handleChatMessage("Debug message", "console", "Console");
        }
        return 1;
    }

    private static int dumpConfig(CommandContext<class_2168> context) {
        class_2168 source = context.getSource();
        String message = String.format("""
                    --------[Config]---------
                    %s
                    -----------------------""",
                CTDCommon.CONFIG_MANAGER.getConfigJsonAsString(false, true));
        source.method_9226(() -> class_2561.method_43470(message).method_27692(class_124.field_1080), false);
        return 1;
    }

    private static int execute(CommandContext<class_2168> context) {
        CTDConfig config = CTDCommon.CONFIG_MANAGER.getConfig();
        List<String> webhooks = config.discord_config.discord_webhooks;

        class_2168 source = context.getSource();
        String whenDebug = config.util_config.debug_mode ? "\n> Debug Enabled" : "";
        String message = String.format("""
                    -----[Chat To Discord]-----
                    > Mod Version: %s
                    > Mod Platform: %s
                    > Config Version: %s
                    > Embed Mode: %s
                    > Only Messages Mode: %s
                    > Webhooks Defined: %s%s
                    -----------------------""", CTDCommon.MOD_V, CTDServices.PLATFORM.getPlatformName(), CTDCommon.CONFIG_MANAGER.getConfig().format_version, config.discord_config.embed_mode, config.discord_config.only_send_messages, webhooks.size(), whenDebug);
        source.method_9226(() -> class_2561.method_43470(message).method_27692(class_124.field_1078), false);
        return 1;
    }

    private static int reload(CommandContext<class_2168> context) {
        return Handlers.handleConfigReload(context);
    }
}
