package org.tywrapstudios.ctd.handlers;

import com.mojang.brigadier.context.CommandContext;
import org.tywrapstudios.blossombridge.api.config.InvalidConfigVersionException;
import org.tywrapstudios.ctd.CTDCommon;
import org.tywrapstudios.ctd.compat.DiscordSafety;
import org.tywrapstudios.ctd.config.CTDConfig;
import org.tywrapstudios.ctd.discord.Discord;

import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

public class Handlers {
    public static void handleChatMessage(String messageStr, String authorUUID, String authorName) {
        CTDConfig config = CTDCommon.CONFIG_MANAGER.getConfig();
        List<String> webhookUrls = config.discord_config.discord_webhooks;

        messageStr = CompatHandlers.handleCompat(messageStr);
        if (!config.discord_config.embed_mode) {
            authorName = DiscordSafety.modifyToNegateMarkdown(authorName);
        }

        if (!webhookUrls.isEmpty()) {
            if (!Objects.equals(authorName, "Rcon")) {
                for (String url : webhookUrls) {
                    if (!config.discord_config.embed_mode) {
                        Discord.sendChatMessageToDiscord(messageStr, authorName, url, authorUUID);
                    } else {
                        Discord.sendEmbedToDiscord(messageStr, authorName, url, authorUUID, config.discord_config.embed_color_rgb_int);
                    }
                }
            } else {
                CTDCommon.LOGGING.debug("The sender was the Server or a Remote Console (RCON).");
            }
        } else {
            CTDCommon.LOGGING.error("[Discord] No webhooks configured! Please configure your webhooks in the Config file: ctd.json");
        }
    }

    public static void handleGameMessage(String message) {
        CTDConfig config = CTDCommon.CONFIG_MANAGER.getConfig();
        boolean embedMode = config.discord_config.embed_mode;
        List<String> webhookUrls = config.discord_config.discord_webhooks;

        message = CompatHandlers.handleCompat(message);
        if (!config.discord_config.only_send_messages) {
            if (!embedMode) {
                message = "**" + message + "**";
            }
            if (!webhookUrls.isEmpty()) {
                for (String url : webhookUrls) {
                    Discord.sendLiteralToDiscord(message, embedMode, url);
                }
            } else {
                CTDCommon.LOGGING.error("[Discord] No webhooks configured! Please configure your webhooks in the Config file: ctd.json");
            }
        }
    }

    public static void handleCrash(String cause, Path report) {
        CTDConfig config = CTDCommon.CONFIG_MANAGER.getConfig();
        List<String> webhookUrls = config.discord_config.discord_webhooks;
        for (String url : webhookUrls) {
            Discord.sendCrashEmbed(cause, 7864320, url, report);
        }
    }

    public static int handleConfigReload(CommandContext<class_2168> context) {
        class_2168 source = context.getSource();
        try {
            source.method_9226(() -> class_2561.method_43470("Reloading!").method_27692(class_124.field_1080), true);
            CTDCommon.CONFIG_MANAGER.loadConfig();
        } catch (InvalidConfigVersionException e) {
            source.method_9226(() -> class_2561.method_43470("Could not reload CTD Config: Version out of sync.").method_27692(class_124.field_1061), true);
            return 0;
        }
        return 1;
    }
}
