package org.tywrapstudios.ctd.platform;

import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import org.tywrapstudios.ctd.command.CTDCommand;
import org.tywrapstudios.ctd.handlers.Handlers;
import org.tywrapstudios.ctd.platform.services.IEventHelper;

public class FabricEventHelper implements IEventHelper {
    @Override
    public void registerServerStarted() {
        ServerLifecycleEvents.SERVER_STARTED.register(minecraftServer -> {
            Handlers.handleChatMessage("Server started.","console","Console");
        });
    }

    @Override
    public void registerServerStopped() {
        ServerLifecycleEvents.SERVER_STOPPED.register(minecraftServer -> {
            Handlers.handleChatMessage("Server stopped.","console","Console");
        });
    }

    @Override
    public void registerChatMessage() {
        ServerMessageEvents.CHAT_MESSAGE.register((signedMessage, serverPlayerEntity, bound) -> {
            String message = signedMessage.method_46291().getString();
            String authorUUID = signedMessage.method_46292().toString();
            String authorName = serverPlayerEntity.method_5477().getString();

            Handlers.handleChatMessage(message, authorUUID, authorName);
        });
    }

    @Override
    public void registerGameMessage() {
        ServerMessageEvents.GAME_MESSAGE.register((minecraftServer, text, b) -> {
            Handlers.handleGameMessage(text.getString());
        });
    }

    @Override
    public void registerCommandMessage() {
        ServerMessageEvents.COMMAND_MESSAGE.register((signedMessage, serverCommandSource, bound) -> {
            String message = signedMessage.method_46291().getString();
            String authorUUID = signedMessage.method_46292().toString();
            String authorName = serverCommandSource.method_9214();

            Handlers.handleChatMessage(message, authorUUID, authorName);
        });
    }

    @Override
    public void registerCommand() {
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated, registrationEnvironment) -> {
            CTDCommand.register(dispatcher);
        });
    }
}
