/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.api.research;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.portingdeadlibs.utils.Utils;
import com.portingdeadmods.researchd.api.research.GlobalResearch;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.ResearchStatus;
import com.portingdeadmods.researchd.impl.research.SimpleResearch;
import com.portingdeadmods.researchd.utils.researches.ResearchHelperCommon;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class ResearchInstance {
    public static final Codec<ResearchInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GlobalResearch.CODEC.fieldOf("research").forGetter(ResearchInstance::getResearch), (App)ResearchStatus.CODEC.fieldOf("research_status").forGetter(ResearchInstance::getResearchStatus), (App)UUIDUtil.CODEC.optionalFieldOf("researched_player").forGetter(r -> Optional.ofNullable(r.getResearchedPlayer())), (App)Codec.LONG.fieldOf("researched_time").forGetter(ResearchInstance::getResearchedTime)).apply((Applicative)instance, (r, s, p, t) -> new ResearchInstance((GlobalResearch)r, (ResearchStatus)((Object)((Object)s)), p.orElse(null), (long)t)));
    public static final StreamCodec<RegistryFriendlyByteBuf, ResearchInstance> STREAM_CODEC = StreamCodec.composite(GlobalResearch.STREAM_CODEC, ResearchInstance::getResearch, ResearchStatus.STREAM_CODEC, ResearchInstance::getResearchStatus, (StreamCodec)ByteBufCodecs.optional((StreamCodec)UUIDUtil.STREAM_CODEC), instance -> Optional.ofNullable(instance.getResearchedPlayer()), (StreamCodec)ByteBufCodecs.VAR_LONG, ResearchInstance::getResearchedTime, (r, s, p, t) -> new ResearchInstance((GlobalResearch)r, (ResearchStatus)((Object)s), p.orElse(null), (long)t));
    private final GlobalResearch research;
    private ResearchStatus researchStatus;
    @Nullable
    private UUID researchedPlayer;
    private long researchedTime;

    public ResearchInstance(GlobalResearch research, ResearchStatus researchStatus, UUID researchedPlayer, long researchedTime) {
        this.research = research;
        this.researchStatus = researchStatus;
        this.researchedPlayer = researchedPlayer;
        this.researchedTime = researchedTime;
    }

    public ResearchInstance(GlobalResearch research, ResearchStatus researchStatus) {
        this(research, researchStatus, null, -1L);
    }

    public boolean isResearched() {
        return this.researchStatus == ResearchStatus.RESEARCHED;
    }

    public boolean isResearchable() {
        return this.researchStatus == ResearchStatus.RESEARCHABLE || this.researchStatus == ResearchStatus.RESEARCHABLE_AFTER_QUEUE;
    }

    public boolean isLocked() {
        return this.researchStatus == ResearchStatus.LOCKED;
    }

    public ResearchInstance withResearch(GlobalResearch research) {
        return new ResearchInstance(research, this.researchStatus, this.researchedPlayer, this.researchedTime);
    }

    public Component getDisplayName() {
        return Utils.registryTranslation(this.getKey());
    }

    public Component getDisplayName(Level level) {
        SimpleResearch simple;
        Research r = this.research.getResearch(level);
        if (r instanceof SimpleResearch && (simple = (SimpleResearch)r).literalName().isPresent()) {
            return Component.literal((String)simple.literalName().get());
        }
        return Utils.registryTranslation(this.getKey());
    }

    public Component getDescription(Level level) {
        SimpleResearch simple;
        Research r = this.research.getResearch(level);
        if (r instanceof SimpleResearch && (simple = (SimpleResearch)r).literalDescription().isPresent()) {
            return Component.literal((String)simple.literalDescription().get());
        }
        ResourceKey<Research> key = this.getKey();
        return Component.translatable((String)("research." + key.location().getNamespace() + "." + key.location().getPath() + ".description"));
    }

    public GlobalResearch getResearch() {
        return this.research;
    }

    public ResourceKey<Research> getKey() {
        return this.research.getResearchKey();
    }

    public ResearchStatus getResearchStatus() {
        return this.researchStatus;
    }

    public ResearchInstance setResearchStatus(ResearchStatus researchStatus) {
        this.researchStatus = researchStatus;
        return this;
    }

    @Nullable
    public UUID getResearchedPlayer() {
        return this.researchedPlayer;
    }

    public ResearchInstance setResearchedPlayer(@Nullable UUID researchedPlayer) {
        this.researchedPlayer = researchedPlayer;
        return this;
    }

    public long getResearchedTime() {
        return this.researchedTime;
    }

    public ResearchInstance setResearchedTime(long researchedTime) {
        this.researchedTime = researchedTime;
        return this;
    }

    public Research lookup(Level level) {
        return ResearchHelperCommon.getResearch(this.research.getResearchKey(), level);
    }

    public Set<GlobalResearch> getChildren() {
        return this.research.getChildren();
    }

    public Set<GlobalResearch> getParents() {
        return this.research.getParents();
    }

    public boolean is(ResearchInstance instance) {
        return this.is(instance.getResearch());
    }

    public boolean is(GlobalResearch research) {
        return this.is(research.getResearchKey());
    }

    public boolean is(ResourceKey<Research> key) {
        return this.research.is(key);
    }

    public ResearchInstance copy() {
        return new ResearchInstance(this.getResearch(), this.getResearchStatus(), this.getResearchedPlayer(), this.getResearchedTime());
    }

    public boolean equals(Object o) {
        if (!(o instanceof ResearchInstance)) {
            return false;
        }
        ResearchInstance instance = (ResearchInstance)o;
        return this.researchedTime == instance.researchedTime && Objects.equals(this.research, instance.research) && this.researchStatus == instance.researchStatus && Objects.equals(this.researchedPlayer, instance.researchedPlayer);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.research, this.researchStatus, this.researchedPlayer, this.researchedTime});
    }

    public String toString() {
        return "ResearchInstance{research=" + String.valueOf(this.research) + ", researchStatus=" + String.valueOf((Object)this.researchStatus) + "}";
    }
}

