/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.api.research.methods;

import com.mojang.serialization.Codec;
import com.portingdeadmods.researchd.ResearchdRegistries;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.serializers.ResearchMethodSerializer;
import com.portingdeadmods.researchd.api.team.ResearchTeam;
import com.portingdeadmods.researchd.content.blockentities.ResearchLabControllerBE;
import com.portingdeadmods.researchd.impl.ResearchProgress;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface ResearchMethod {
    public static final Codec<ResearchMethod> CODEC = ResearchdRegistries.RESEARCH_METHOD_SERIALIZER.byNameCodec().dispatch(ResearchMethod::getSerializer, ResearchMethodSerializer::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, ResearchMethod> STREAM_CODEC = ResearchMethodSerializer.STREAM_CODEC.dispatch(ResearchMethod::getSerializer, ResearchMethodSerializer::streamCodec);

    public ResourceLocation id();

    public void checkProgress(Level var1, ResourceKey<Research> var2, ResearchProgress.Task var3, MethodContext var4);

    public ResearchProgress createProgress();

    public float getMaxProgress();

    default public boolean shouldCheckProgress() {
        return true;
    }

    default public Component getTranslation() {
        ResourceLocation id = this.id();
        return Component.translatable((String)("research_method." + id.getNamespace() + "." + id.getPath()));
    }

    public ResearchMethodSerializer<?> getSerializer();

    public record SimpleMethodContext(ResearchTeam team, @Nullable ResearchLabControllerBE blockEntity) implements MethodContext
    {
    }

    public static interface MethodContext {
        public ResearchTeam team();
    }
}

