/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.api.research.packs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.portingdeadmods.portingdeadlibs.api.utils.RGBAColor;
import com.portingdeadmods.researchd.ResearchdRegistries;
import com.portingdeadmods.researchd.data.components.ResearchPackComponent;
import com.portingdeadmods.researchd.registries.ResearchdDataComponents;
import com.portingdeadmods.researchd.registries.ResearchdItems;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;

public record ResearchPack(int color, int sortingValue, Optional<ResourceLocation> customTexture) {
    public static final Codec<ResearchPack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RGBAColor.CODEC.fieldOf("color").forGetter(ResearchPack::colorAsRgba), (App)Codec.INT.fieldOf("sorting_value").forGetter(ResearchPack::sortingValue), (App)ResourceLocation.CODEC.optionalFieldOf("custom_texture").forGetter(ResearchPack::customTexture)).apply((Applicative)instance, ResearchPack::new));
    public static final StreamCodec<? super RegistryFriendlyByteBuf, ResearchPack> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ResearchPack::color, (StreamCodec)ByteBufCodecs.INT, ResearchPack::sortingValue, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), ResearchPack::customTexture, ResearchPack::new);
    public static final Codec<ResourceKey<ResearchPack>> RESOURCE_KEY_CODEC = ResourceKey.codec(ResearchdRegistries.RESEARCH_PACK_KEY);
    public static final StreamCodec<ByteBuf, ResourceKey<ResearchPack>> RESOURCE_KEY_STREAM_CODEC = ResourceKey.streamCodec(ResearchdRegistries.RESEARCH_PACK_KEY);
    public static final ResearchPack EMPTY = new ResearchPack(-1, -1, Optional.empty());

    public ResearchPack(ResourceLocation customTexture) {
        this(-1, -1, Optional.of(customTexture));
    }

    public ResearchPack(RGBAColor color, int sortingValue, Optional<ResourceLocation> customTexture) {
        this(color.toARGB(), sortingValue, customTexture);
    }

    public RGBAColor colorAsRgba() {
        int red = FastColor.ARGB32.red((int)this.color);
        int green = FastColor.ARGB32.green((int)this.color);
        int blue = FastColor.ARGB32.blue((int)this.color);
        int alpha = FastColor.ARGB32.alpha((int)this.color);
        return new RGBAColor(red, green, blue, alpha);
    }

    public static ItemStack asStack(ResourceKey<ResearchPack> key) {
        ItemStack stack = ResearchdItems.RESEARCH_PACK.toStack();
        stack.set(ResearchdDataComponents.RESEARCH_PACK, (Object)new ResearchPackComponent(Optional.of(key)));
        return stack;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int color = -1;
        private int sorting_value = -1;
        private ResourceLocation customTexture;

        private Builder() {
        }

        public Builder color(int r, int g, int b) {
            this.color = FastColor.ARGB32.color((int)r, (int)g, (int)b);
            return this;
        }

        public Builder customTexture(ResourceLocation customTexture) {
            this.customTexture = customTexture;
            return this;
        }

        public Builder sortingValue(int sortingValue) {
            this.sorting_value = sortingValue;
            return this;
        }

        public ResearchPack build() {
            return new ResearchPack(this.color, this.sorting_value, Optional.ofNullable(this.customTexture));
        }
    }
}

