/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.cache;

import com.google.common.collect.ImmutableMap;
import com.portingdeadmods.portingdeadlibs.utils.UniqueArray;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.research.GlobalResearch;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.utils.researches.ResearchHelperCommon;
import com.portingdeadmods.researchd.utils.researches.ResearchdManagers;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public final class CommonResearchCache {
    public static Map<ResourceKey<Research>, GlobalResearch> GLOBAL_RESEARCHES;
    @Nullable
    public static GlobalResearch ROOT_RESEARCH;

    public static void initialize(Level level) {
        List<ResourceKey<Research>> parents;
        Research research1;
        CommonResearchCache.reset();
        Map<ResourceKey<Research>, Research> researchLookup = ResearchHelperCommon.getLevelResearches(level);
        HashMap<ResourceKey<Research>, GlobalResearch> globalResearchMap = new HashMap<ResourceKey<Research>, GlobalResearch>(researchLookup.size());
        for (ResourceKey<Research> key : researchLookup.keySet()) {
            globalResearchMap.put(key, new GlobalResearch(key));
        }
        for (GlobalResearch research : globalResearchMap.values()) {
            research1 = researchLookup.get(research.getResearchKey());
            parents = research1.parents();
            for (ResourceKey<Research> parent : parents) {
                GlobalResearch parentGlobalResearch = (GlobalResearch)globalResearchMap.get(parent);
                parentGlobalResearch.getChildren().add(research);
            }
        }
        for (GlobalResearch research : globalResearchMap.values()) {
            research1 = researchLookup.get(research.getResearchKey());
            parents = research1.parents();
            if (parents.isEmpty()) {
                if (ROOT_RESEARCH == null) {
                    ROOT_RESEARCH = research;
                    continue;
                }
                try {
                    throw new IllegalStateException("Multiple research roots (Researches without parents), prev root research: %s, other root research: %s".formatted(ROOT_RESEARCH.getResearchKey().location(), research.getResearchKey().location()));
                }
                catch (Exception e) {
                    Researchd.LOGGER.error(e.getMessage());
                    GLOBAL_RESEARCHES = Collections.emptyMap();
                    ResearchdManagers.getResearchesManager(level).fail();
                    return;
                }
            }
            for (ResourceKey<Research> parent : parents) {
                research.getParents().add((GlobalResearch)globalResearchMap.get(parent));
            }
        }
        for (GlobalResearch research : globalResearchMap.values()) {
            research.lock();
        }
        GLOBAL_RESEARCHES = ImmutableMap.copyOf(globalResearchMap);
    }

    private static void _collectChildren(GlobalResearch research, List<GlobalResearch> list) {
        for (GlobalResearch child : research.getChildren()) {
            list.add(child);
            if (child.getChildren().isEmpty()) continue;
            CommonResearchCache._collectChildren(child, list);
        }
    }

    public static List<GlobalResearch> allChildrenOf(ResourceKey<Research> key) {
        UniqueArray list = new UniqueArray();
        CommonResearchCache._collectChildren(GLOBAL_RESEARCHES.get(key), (List<GlobalResearch>)list);
        return list;
    }

    private static void _collectParents(GlobalResearch research, List<GlobalResearch> list) {
        for (GlobalResearch parent : research.getParents()) {
            list.add(parent);
            if (parent.getParents().isEmpty()) continue;
            CommonResearchCache._collectChildren(parent, list);
        }
    }

    public static List<GlobalResearch> allParentsOf(ResourceKey<Research> key) {
        UniqueArray list = new UniqueArray();
        CommonResearchCache._collectParents(GLOBAL_RESEARCHES.get(key), (List<GlobalResearch>)list);
        return list;
    }

    public static void reset() {
        if (GLOBAL_RESEARCHES != null) {
            ROOT_RESEARCH = null;
            GLOBAL_RESEARCHES = null;
        }
    }
}

