/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.impl;

import com.mojang.blaze3d.vertex.PoseStack;
import com.portingdeadmods.researchd.api.client.ClientResearchIcon;
import com.portingdeadmods.researchd.api.client.renderers.CycledItemRenderer;
import com.portingdeadmods.researchd.impl.research.ItemResearchIcon;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;

public final class ClientItemResearchIcon
implements ClientResearchIcon<ItemResearchIcon> {
    private final ItemResearchIcon icon;
    private final CycledItemRenderer renderer;

    public ClientItemResearchIcon(ItemResearchIcon icon) {
        this.icon = icon;
        List<ItemStack> stacks = icon.items();
        this.renderer = new CycledItemRenderer(stacks.size());
        this.renderer.setItems(stacks);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int panelLeft, int panelTop, int mouseX, int mouseY, float scale, float partialTicks) {
        if (scale != 1.0f) {
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate((float)panelLeft, (float)panelTop, 0.0f);
            poseStack.scale(scale, scale, scale);
            int itemX = 2;
            int itemY = 3;
            this.renderer.render(guiGraphics, itemX, itemY);
            poseStack.popPose();
        } else {
            this.renderer.render(guiGraphics, panelLeft, panelTop);
        }
    }

    @Override
    public ItemResearchIcon icon() {
        return this.icon;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ClientItemResearchIcon that = (ClientItemResearchIcon)obj;
        return Objects.equals(this.icon, that.icon);
    }

    public int hashCode() {
        return Objects.hash(this.icon);
    }

    public String toString() {
        return "ClientItemResearchIcon[icon=" + String.valueOf(this.icon) + "]";
    }
}

