/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.impl.methods;

import com.portingdeadmods.researchd.ResearchdClient;
import com.portingdeadmods.researchd.api.client.widgets.AbstractResearchInfoWidget;
import com.portingdeadmods.researchd.api.research.methods.ResearchMethod;
import com.portingdeadmods.researchd.api.research.methods.ResearchMethodList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.util.FastColor;
import net.neoforged.neoforge.common.util.Size2i;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractResearchMethodListWidget<T extends ResearchMethodList>
extends AbstractResearchInfoWidget<T> {
    private final List<AbstractResearchInfoWidget<? extends ResearchMethod>> methods = new ArrayList<AbstractResearchInfoWidget<? extends ResearchMethod>>();

    public AbstractResearchMethodListWidget(int x, int y, T method) {
        super(x, y, method);
        List<ResearchMethod> methods = method.methods();
        for (int i = 0; i < methods.size(); ++i) {
            ResearchMethod researchMethod = methods.get(i);
            int xSize = i > 0 ? (int)((float)this.getSizeFor((int)i, (boolean)false).width + (float)i * this.getPadding()) : 0;
            this.methods.add(ResearchdClient.RESEARCH_METHOD_WIDGETS.get(researchMethod.id()).createMethod(x + xSize + 1, y + 1, researchMethod));
        }
        Size2i size = this.getSize(true);
        this.setWidth(size.width);
        this.setHeight(size.height);
    }

    public void visitWidgets(@NotNull Consumer<AbstractWidget> consumer) {
        super.visitWidgets(consumer);
        for (AbstractResearchInfoWidget<? extends ResearchMethod> widget : this.methods) {
            consumer.accept(widget);
        }
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.getX();
        int y = this.getY();
        Size2i firstSize = this.getSizeFor(1, false);
        guiGraphics.fill(x, y, x + this.width, y + firstSize.height, FastColor.ARGB32.color((int)109, (int)109, (int)109));
        List<ResearchMethod> methods = ((ResearchMethodList)this.value).methods();
        for (int i = 0; i < methods.size(); ++i) {
            this.methods.get(i).render(guiGraphics, mouseX, mouseY, partialTicks);
            float padding = this.getPadding();
            if (i <= 0 || i - 1 == methods.size()) continue;
            int xSize1 = (int)((float)this.getSizeFor((int)i, (boolean)false).width + (float)(i - 1) * padding);
            Objects.requireNonNull(Minecraft.getInstance().font);
            int ySize = (this.height - 9) / 2 + 1;
            guiGraphics.drawCenteredString(Minecraft.getInstance().font, this.getSeparatorText(), (int)((float)(x + xSize1) + this.getPadding() / 2.0f), y + ySize, -1);
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        for (AbstractResearchInfoWidget<? extends ResearchMethod> researchMethod : this.methods) {
            researchMethod.renderTooltip(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    @NotNull
    public abstract String getSeparatorText();

    @Override
    public Size2i getSize() {
        return this.getSizeFor(((ResearchMethodList)this.value).methods().size(), false);
    }

    public void setY(int y) {
        super.setY(y);
        for (AbstractResearchInfoWidget<? extends ResearchMethod> method : this.methods) {
            method.setY(y + 1);
        }
    }

    public float getPadding() {
        Font font = Minecraft.getInstance().font;
        return font.width(this.getSeparatorText()) + 4;
    }

    public Size2i getSize(boolean includePadding) {
        return this.getSizeFor(((ResearchMethodList)this.value).methods().size(), includePadding);
    }

    @NotNull
    public Size2i getSizeFor(int amount, boolean includePadding) {
        List<AbstractResearchInfoWidget<? extends ResearchMethod>> methods = this.methods;
        if (methods == null) {
            methods = new ArrayList<AbstractResearchInfoWidget<? extends ResearchMethod>>();
            for (ResearchMethod researchMethod : ((ResearchMethodList)this.value).methods()) {
                methods.add(ResearchdClient.RESEARCH_METHOD_WIDGETS.get(researchMethod.id()).createMethod(0, 0, researchMethod));
            }
        }
        if (!methods.isEmpty()) {
            Size2i firstMethodSize = methods.getFirst().getSize();
            Size2i size = new Size2i(0, firstMethodSize.height + 2);
            for (int i = 0; i < amount; ++i) {
                AbstractResearchInfoWidget<? extends ResearchMethod> researchMethod = methods.get(i);
                size = new Size2i((int)((float)(size.width + researchMethod.getWidth()) + (includePadding && i > 0 ? this.getPadding() : 0.0f)) + 2, size.height);
            }
            return size;
        }
        return new Size2i(0, 0);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        for (AbstractResearchInfoWidget<? extends ResearchMethod> method : this.methods) {
            if (!method.isHovered()) continue;
            return method.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }
}

