/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.portingdeadmods.portingdeadlibs.utils.AABBUtils;
import com.portingdeadmods.researchd.content.blockentities.ResearchLabControllerBE;
import com.portingdeadmods.researchd.content.blocks.ResearchLabController;
import com.portingdeadmods.researchd.registries.ResearchdBlocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class ResearchLabBER
implements BlockEntityRenderer<ResearchLabControllerBE> {
    private final BlockEntityRendererProvider.Context context;
    private final BakedModel model;
    private final BlockState blockState;
    private static final double PACK_RENDERING_HEIGHT = 1.4;
    private static final double PACK_RENDERING_RADIUS = 0.75;

    public ResearchLabBER(BlockEntityRendererProvider.Context context) {
        Minecraft mc = Minecraft.getInstance();
        BlockRenderDispatcher blockRenderer = mc.getBlockRenderer();
        this.context = context;
        this.model = blockRenderer.getBlockModel(((ResearchLabController)((Object)ResearchdBlocks.RESEARCH_LAB_CONTROLLER.get())).defaultBlockState());
        this.blockState = ((ResearchLabController)((Object)ResearchdBlocks.RESEARCH_LAB_CONTROLLER.get())).defaultBlockState();
    }

    public void render(ResearchLabControllerBE researchLabControllerBE, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        poseStack.scale(1.0714285f, 1.0714285f, 1.0714285f);
        poseStack.translate(0.5, 0.0, 0.5);
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        BlockState state = researchLabControllerBE.getBlockState();
        BlockPos pos = researchLabControllerBE.getBlockPos();
        blockRenderer.getModelRenderer().tesselateBlock((BlockAndTintGetter)researchLabControllerBE.getLevel(), this.model, state, pos, poseStack, multiBufferSource.getBuffer(RenderTypeHelper.getEntityRenderType((RenderType)RenderType.TRANSLUCENT, (boolean)false)), true, researchLabControllerBE.getLevel().random, state.getSeed(pos), OverlayTexture.NO_OVERLAY, ModelData.EMPTY, RenderTypeHelper.getEntityRenderType((RenderType)RenderType.TRANSLUCENT, (boolean)false));
        poseStack.popPose();
        for (ItemStack pack : researchLabControllerBE.getItemHandlerStacksList()) {
            double theta;
            double len = researchLabControllerBE.getItemHandlerStacksList().size();
            double idx = researchLabControllerBE.getItemHandlerStacksList().indexOf(pack);
            float duration = 50.0f * (float)len;
            if (researchLabControllerBE.getLevel() != null) {
                theta = (float)researchLabControllerBE.getLevel().getGameTime() % duration / duration;
            } else {
                System.out.println("Level is null for some reason");
                theta = 0.0;
            }
            double sin = Math.sin(Math.PI * 2 * (idx / len + theta)) * 0.75;
            double cos = Math.cos(Math.PI * 2 * (idx / len + theta)) * 0.75;
            poseStack.pushPose();
            float bonus = idx % 2.0 == 0.0 ? 0.25f : -0.25f;
            poseStack.translate(sin + 0.5, 1.4 + Math.sin(((double)bonus + theta) * Math.PI * 2.0) * 0.1, cos + 0.5);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            double angle = -360.0 * (idx / len + theta);
            poseStack.mulPose(Axis.YN.rotationDegrees((float)angle));
            this.context.getItemRenderer().renderStatic(pack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, multiBufferSource, researchLabControllerBE.getLevel(), (int)this.blockState.getSeed(researchLabControllerBE.getBlockPos()));
            poseStack.popPose();
        }
    }

    @NotNull
    public AABB getRenderBoundingBox(ResearchLabControllerBE blockEntity) {
        return AABBUtils.move((AABB)new AABB(blockEntity.getBlockPos()), (Direction)Direction.UP, (double)1.0).inflate(1.0);
    }
}

