/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.screens.research;

import com.portingdeadmods.portingdeadlibs.utils.renderers.GuiUtils;
import com.portingdeadmods.researchd.api.client.ClientResearchIcon;
import com.portingdeadmods.researchd.api.research.ResearchInstance;
import com.portingdeadmods.researchd.api.research.ResearchStatus;
import com.portingdeadmods.researchd.client.screens.research.ResearchScreen;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;

public abstract class ResearchScreenWidget
extends AbstractWidget {
    public static final int PANEL_WIDTH = 20;
    public static final int SMALL_PANEL_HEIGHT = 22;
    public static final int PANEL_HEIGHT = 24;
    public static final int TALL_PANEL_HEIGHT = 32;

    public ResearchScreenWidget(int x, int y, int width, int height) {
        super(x, y, width, height, CommonComponents.EMPTY);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public static void renderResearchPanel(GuiGraphics guiGraphics, ResearchInstance instance, int x, int y, int mouseX, int mouseY, float scale) {
        ResearchScreenWidget.renderResearchPanel(guiGraphics, instance, x, y, mouseX, mouseY, scale, true);
    }

    public static void renderResearchPanel(GuiGraphics guiGraphics, ResearchInstance instance, int x, int y, int mouseX, int mouseY, float scale, boolean hoverable) {
        ResearchScreenWidget.renderResearchPanel(guiGraphics, instance, x, y, mouseX, mouseY, scale, hoverable, false);
    }

    public static void renderResearchPanel(GuiGraphics guiGraphics, ResearchInstance instance, int x, int y, int mouseX, int mouseY, float scale, boolean hoverable, boolean tall) {
        int width = 20;
        int height = 24;
        ResearchStatus status = instance.getResearchStatus();
        guiGraphics.blit(status.getSpriteTexture(), x, y, (int)((float)width * scale), (int)((float)height * scale), 0.0f, 0.0f, width, height, width, height);
        ClientResearchIcon<?> clientResearchIcon = ResearchScreen.CLIENT_ICONS.get(instance.getKey().location());
        if (clientResearchIcon != null) {
            clientResearchIcon.render(guiGraphics, x, y, mouseX, mouseY, scale, 0.0f);
        }
        if (ResearchScreenWidget.isHovering(guiGraphics, x, y, mouseX, mouseY, scale) && hoverable) {
            int color = -2130706433;
            guiGraphics.fillGradient(RenderType.guiOverlay(), x, y, (int)((float)x + 20.0f * scale), (int)((float)y + 20.0f * scale), color, color, 0);
        }
    }

    public static void renderSmallResearchPanel(GuiGraphics guiGraphics, ResearchInstance instance, int x, int y, int mouseX, int mouseY) {
        ResearchScreenWidget.renderResearchPanel(guiGraphics, instance, x, y, mouseX, mouseY, true, PanelSpriteType.SMALL);
    }

    public static void renderResearchPanel(GuiGraphics guiGraphics, ResearchInstance instance, int x, int y, int mouseX, int mouseY) {
        ResearchScreenWidget.renderResearchPanel(guiGraphics, instance, x, y, mouseX, mouseY, true, PanelSpriteType.NORMAL);
    }

    public static void renderTallResearchPanel(GuiGraphics guiGraphics, ResearchInstance instance, int x, int y, int mouseX, int mouseY) {
        ResearchScreenWidget.renderResearchPanel(guiGraphics, instance, x, y, mouseX, mouseY, true, PanelSpriteType.TALL);
    }

    public static void renderResearchPanel(GuiGraphics guiGraphics, ResearchInstance instance, int x, int y, int mouseX, int mouseY, boolean hoverable, PanelSpriteType spriteType) {
        ResearchStatus status = instance.getResearchStatus();
        GuiUtils.drawImg((GuiGraphics)guiGraphics, (ResourceLocation)status.getSpriteTexture(spriteType), (int)x, (int)y, (int)20, (int)spriteType.getHeight());
        ClientResearchIcon<?> clientResearchIcon = ResearchScreen.CLIENT_ICONS.get(instance.getKey().location());
        if (clientResearchIcon != null) {
            clientResearchIcon.render(guiGraphics, x + 2, y + 2, mouseX, mouseY, 1.0f, 0.0f);
        }
        if (ResearchScreenWidget.isHovering(guiGraphics, x, y, mouseX, mouseY) && hoverable) {
            int color = -2130706433;
            guiGraphics.fillGradient(RenderType.guiOverlay(), x, y, x + 20, y + 20, color, color, 0);
        }
    }

    public static boolean isHovering(@Nullable GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        return ResearchScreenWidget.isHovering(guiGraphics, x, y, mouseX, mouseY, 1.0f);
    }

    public static boolean isHovering(@Nullable GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float scale) {
        return (guiGraphics == null || guiGraphics.containsPointInScissor(mouseX, mouseY)) && mouseX >= x && mouseY >= y && (float)mouseX < (float)x + 20.0f * scale && (float)mouseY < (float)y + 24.0f * scale;
    }

    public static enum PanelSpriteType {
        TALL(32),
        NORMAL(24),
        SMALL(22);

        private final int height;

        private PanelSpriteType(int height) {
            this.height = height;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

