/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.screens.research.graph.lines;

import com.portingdeadmods.portingdeadlibs.utils.UniqueArray;
import com.portingdeadmods.researchd.client.screens.research.graph.ResearchNode;
import java.awt.Point;
import java.util.Collection;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.FastColor;

public class ResearchHead {
    private int x;
    private int y;
    private final boolean isInput;
    private int color = FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255);

    public ResearchHead(int x, int y, boolean isInput) {
        this.x = x;
        this.y = y;
        this.isInput = isInput;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public Point getConnectionPoint() {
        return this.isInput ? new Point(this.x, this.y - 3) : new Point(this.x, this.y + 3);
    }

    public boolean isInput() {
        return this.isInput;
    }

    public void translate(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public void render(GuiGraphics graphics) {
        if (this.isInput) {
            graphics.vLine(this.x, this.y - 4, this.y, this.getColor());
        } else {
            graphics.vLine(this.x, this.y, this.y + 4, this.getColor());
        }
    }

    public static UniqueArray<ResearchHead> inputsOf(ResearchNode node) {
        UniqueArray positions = new UniqueArray();
        UniqueArray<ResearchNode> parents = node.getParents();
        int parentCount = parents.size();
        int width = 20;
        if (parentCount == 0) {
            return positions;
        }
        if (parentCount == 1) {
            int x = node.getX() + width / 2;
            int y = node.getY();
            positions.add((Object)new ResearchHead(x, y, true));
            return positions;
        }
        int startingX = parentCount % 2 == 0 ? node.getX() + width / 2 - 2 : node.getX() + width / 2;
        startingX -= (parentCount - 1) / 2 * 3;
        for (int i = 0; i < parentCount; ++i) {
            positions.addLast((Object)new ResearchHead(startingX + i * 3, node.getY(), true));
        }
        return positions;
    }

    public static UniqueArray<ResearchHead> outputsOf(ResearchNode node) {
        UniqueArray positions = new UniqueArray();
        UniqueArray<ResearchNode> children = node.getChildren();
        int childCount = children.size();
        int width = 20;
        if (childCount == 0) {
            return positions;
        }
        if (childCount == 1) {
            int x = node.getX() + width / 2;
            int y = node.getY() + 24 - 1;
            positions.add((Object)new ResearchHead(x, y, false));
            return positions;
        }
        int startingX = childCount % 2 == 0 ? node.getX() + width / 2 - 2 : node.getX() + width / 2;
        startingX -= (childCount - 1) / 2 * 3;
        for (int i = 0; i < childCount; ++i) {
            positions.addLast((Object)new ResearchHead(startingX + i * 3, node.getY() + 24 - 1, false));
        }
        return positions;
    }

    public static UniqueArray<ResearchHead> inputsOf(ResearchNode node, Collection<ResearchNode> visibleNodes) {
        UniqueArray positions = new UniqueArray();
        UniqueArray parents = new UniqueArray();
        for (ResearchNode parent : node.getParents()) {
            if (!visibleNodes.contains((Object)parent)) continue;
            parents.add((Object)parent);
        }
        int parentCount = parents.size();
        int width = 20;
        if (parentCount == 0) {
            return positions;
        }
        if (parentCount == 1) {
            int x = node.getX() + width / 2;
            int y = node.getY();
            positions.add((Object)new ResearchHead(x, y, true));
            return positions;
        }
        int startingX = parentCount % 2 == 0 ? node.getX() + width / 2 - 2 : node.getX() + width / 2;
        startingX -= (parentCount - 1) / 2 * 3;
        for (int i = 0; i < parentCount; ++i) {
            positions.addLast((Object)new ResearchHead(startingX + i * 3, node.getY(), true));
        }
        return positions;
    }

    public static UniqueArray<ResearchHead> outputsOf(ResearchNode node, Collection<ResearchNode> visibleNodes) {
        UniqueArray positions = new UniqueArray();
        UniqueArray children = new UniqueArray();
        for (ResearchNode child : node.getChildren()) {
            if (!visibleNodes.contains((Object)child)) continue;
            children.add((Object)child);
        }
        int childCount = children.size();
        int width = 20;
        if (childCount == 0) {
            return positions;
        }
        if (childCount == 1) {
            int x = node.getX() + width / 2;
            int y = node.getY() + 24 - 1;
            positions.add((Object)new ResearchHead(x, y, false));
            return positions;
        }
        int startingX = childCount % 2 == 0 ? node.getX() + width / 2 - 2 : node.getX() + width / 2;
        startingX -= (childCount - 1) / 2 * 3;
        for (int i = 0; i < childCount; ++i) {
            positions.addLast((Object)new ResearchHead(startingX + i * 3, node.getY() + 24 - 1, false));
        }
        return positions;
    }

    public static UniqueArray<ResearchHead> createInputHeads(ResearchNode node, int count) {
        UniqueArray heads = new UniqueArray();
        if (count <= 0) {
            return heads;
        }
        int width = 20;
        int x = node.getX();
        int y = node.getY();
        if (count == 1) {
            heads.add((Object)new ResearchHead(x + width / 2, y, true));
            return heads;
        }
        int startingX = count % 2 == 0 ? x + width / 2 - 2 : x + width / 2;
        startingX -= (count - 1) / 2 * 3;
        for (int i = 0; i < count; ++i) {
            heads.add((Object)new ResearchHead(startingX + i * 3, y, true));
        }
        return heads;
    }

    public static UniqueArray<ResearchHead> createOutputHeads(ResearchNode node, int count) {
        UniqueArray heads = new UniqueArray();
        if (count <= 0) {
            return heads;
        }
        int width = 20;
        int height = 24;
        int x = node.getX();
        int y = node.getY() + height - 1;
        if (count == 1) {
            heads.add((Object)new ResearchHead(x + width / 2, y, false));
            return heads;
        }
        int startingX = count % 2 == 0 ? x + width / 2 - 2 : x + width / 2;
        startingX -= (count - 1) / 2 * 3;
        for (int i = 0; i < count; ++i) {
            heads.add((Object)new ResearchHead(startingX + i * 3, y, false));
        }
        return heads;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }
}

