/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.screens.research.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.portingdeadmods.portingdeadlibs.utils.renderers.GuiUtils;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.ResearchInstance;
import com.portingdeadmods.researchd.api.research.ResearchStatus;
import com.portingdeadmods.researchd.api.team.ResearchQueue;
import com.portingdeadmods.researchd.client.cache.ResearchGraphCache;
import com.portingdeadmods.researchd.client.screens.research.ResearchScreen;
import com.portingdeadmods.researchd.client.screens.research.ResearchScreenWidget;
import com.portingdeadmods.researchd.client.utils.ClientResearchTeamHelper;
import com.portingdeadmods.researchd.data.ResearchdSavedData;
import com.portingdeadmods.researchd.impl.ResearchProgress;
import com.portingdeadmods.researchd.impl.team.ResearchTeamMap;
import com.portingdeadmods.researchd.networking.research.ResearchQueueRemovePayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class ResearchQueueWidget
extends ResearchScreenWidget {
    private static final ResourceLocation BACKGROUND_TEXTURE = Researchd.rl("textures/gui/research_queue.png");
    private static final int BACKGROUND_WIDTH = 174;
    private static final int BACKGROUND_HEIGHT = 40;
    private final ResearchScreen screen;
    private ResearchQueue queue;
    private ResearchInstance selected;
    private float selectedX;
    private float selectedY;

    public void setQueue(ResearchQueue newQueue) {
        this.queue = newQueue;
    }

    public ResearchQueueWidget(ResearchScreen screen, int x, int y) {
        super(x, y, 174, 40);
        this.screen = screen;
        this.queue = ((ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData((Level)Minecraft.getInstance().level)).getTeamByPlayer((Player)Minecraft.getInstance().player).getQueue();
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        GuiUtils.drawImg((GuiGraphics)guiGraphics, (ResourceLocation)BACKGROUND_TEXTURE, (int)this.getX(), (int)this.getY(), (int)this.width, (int)this.height);
        int paddingX = 12;
        int paddingY = 14;
        guiGraphics.drawString(Minecraft.getInstance().font, "Research Queue", paddingX - 1, 4, -1);
        int selectedIndex = 0;
        for (int i = 0; i < this.queue.size(); ++i) {
            ResourceKey<Research> key = this.queue.get(i);
            if (this.selected == null || key != this.selected.getKey()) {
                ResearchInstance instance = ClientResearchTeamHelper.getTeam().getResearches().get(key);
                this.renderQueuePanel(guiGraphics, instance, paddingX + i * 20, paddingY, mouseX, mouseY, i);
                continue;
            }
            selectedIndex = i;
        }
        if (this.selected != null) {
            this.renderQueuePanel(guiGraphics, this.selected, (int)this.selectedX, (int)this.selectedY, mouseX, mouseY, selectedIndex);
        }
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        super.onDrag(mouseX, mouseY, dragX, dragY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int paddingX = 12;
        int paddingY = 14;
        int index = (int)(mouseX - (double)paddingX) / 20;
        if (mouseX > (double)paddingX && mouseY > (double)paddingY && index < this.queue.size()) {
            ResourceKey<Research> researchKey = this.queue.get(index);
            if (this.isHovering(null, (int)mouseX, (int)mouseY, index, paddingY + 17, this.getWidth(), this.getHeight() - 17)) {
                this.removeResearch(index);
                this.screen.getTechListWidget().startResearchButton.active = true;
                return super.mouseClicked(mouseX, mouseY, button);
            }
            if (this.isHovering(null, (int)mouseX, (int)mouseY, index, paddingY, this.getWidth(), this.getHeight())) {
                ResearchInstance instance = ClientResearchTeamHelper.getTeam().getResearches().get(researchKey);
                this.screen.getSelectedResearchWidget().setSelectedResearch(instance);
                this.screen.getResearchGraphWidget().setGraph(ResearchGraphCache.computeIfAbsent(researchKey));
                ClientResearchTeamHelper.refreshGraphData();
                return super.mouseClicked(mouseX, mouseY, button);
            }
        }
        return false;
    }

    public void removeResearch(int index) {
        if (this.queue.size() > index) {
            ResourceKey<Research> researchKey = this.queue.get(index);
            this.queue.remove(index, true);
            PacketDistributor.sendToServer((CustomPacketPayload)new ResearchQueueRemovePayload(researchKey), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ClientResearchTeamHelper.getTeam().refreshResearchStatus();
            ClientResearchTeamHelper.refreshResearchScreenData();
        }
    }

    private void renderQueuePanel(GuiGraphics guiGraphics, ResearchInstance instance, int x, int y, int mouseX, int mouseY, int index) {
        if (instance == null) {
            return;
        }
        if (index == 0) {
            this.renderResearchingResearchPanel(guiGraphics, instance, x, y, mouseX, mouseY, false);
        } else {
            ResearchQueueWidget.renderResearchPanel(guiGraphics, instance, x, y, mouseX, mouseY, false, ResearchScreenWidget.PanelSpriteType.NORMAL);
        }
        if (this.isHovering(guiGraphics, mouseX, mouseY, x, y, 20, 24)) {
            Font font = Minecraft.getInstance().font;
            int color = FastColor.ARGB32.color((int)120, (int)20, (int)20, (int)20);
            if (this.isHovering(guiGraphics, mouseX, mouseY, x, y + 17, 20, 7)) {
                color = FastColor.ARGB32.color((int)120, (int)90, (int)90, (int)90);
            }
            guiGraphics.fillGradient(x, y + 17, x + 20, y + 24, color, color);
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 1000.0f);
            guiGraphics.drawString(font, "x", x + 10 - font.width("x") / 2, y + 16, -1, false);
            poseStack.popPose();
        }
    }

    private void renderResearchingResearchPanel(GuiGraphics guiGraphics, ResearchInstance instance, int x, int y, int mouseX, int mouseY, boolean hoverable) {
        ResearchScreenWidget.PanelSpriteType spriteType = ResearchScreenWidget.PanelSpriteType.NORMAL;
        ResearchStatus status = instance.getResearchStatus();
        GuiUtils.drawImg((GuiGraphics)guiGraphics, (ResourceLocation)status.getSpriteTexture(spriteType), (int)x, (int)y, (int)20, (int)spriteType.getHeight());
        ResearchProgress rmp = ClientResearchTeamHelper.getTeam().getResearchProgresses().get(instance.getKey());
        float progress = rmp == null ? 0.0f : rmp.getProgress() / rmp.getMaxProgress();
        guiGraphics.blit(ResearchStatus.RESEARCHED.getSpriteTexture(spriteType), x, y, 0.0f, 0.0f, (int)(progress * 20.0f), spriteType.getHeight(), 20, spriteType.getHeight());
        ResearchScreen.CLIENT_ICONS.get(instance.getKey().location()).render(guiGraphics, x + 2, y + 2, mouseX, mouseY, 1.0f, 0.0f);
        if (ResearchQueueWidget.isHovering(guiGraphics, x, y, mouseX, mouseY) && hoverable) {
            int color = -2130706433;
            guiGraphics.fillGradient(RenderType.guiOverlay(), x, y, x + 20, y + 20, color, color, 0);
        }
    }

    private boolean isHovering(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y, int width, int height) {
        return (guiGraphics == null || guiGraphics.containsPointInScissor(mouseX, mouseY)) && mouseX >= x && mouseY >= y && mouseX < x + width && mouseY < y + height;
    }

    public ResearchQueue getQueue() {
        return this.queue;
    }
}

