/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.screens.team.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.portingdeadmods.portingdeadlibs.utils.PlayerUtils;
import com.portingdeadmods.portingdeadlibs.utils.renderers.GuiUtils;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.team.TeamMember;
import com.portingdeadmods.researchd.client.screens.team.ResearchTeamScreen;
import com.portingdeadmods.researchd.client.screens.team.widgets.AbstractDraggableWidget;
import com.portingdeadmods.researchd.client.screens.team.widgets.DraggableWidgetImageButton;
import com.portingdeadmods.researchd.client.screens.team.widgets.PlayerManagementList;
import com.portingdeadmods.researchd.client.screens.team.widgets.WarningPopupWidget;
import com.portingdeadmods.researchd.client.utils.ClientResearchTeamHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class PlayerManagementDraggableWidget
extends AbstractDraggableWidget {
    public static final ResourceLocation WINDOW_TEXTURE = Researchd.rl("textures/gui/player_management_window.png");
    private final PlayerManagementButtons buttonSettings;
    private final List<DraggableWidgetImageButton> buttonWidgets;
    private final PlayerManagementList managementList;
    public final WarningPopupWidget popupWidget;
    public final BiConsumer<PlayerManagementList.Entry, PlayerManagementButtonType> refreshFunction;
    public static final int BACKGROUND_Z = 500;

    public PlayerManagementList getManagementList() {
        return this.managementList;
    }

    public PlayerManagementDraggableWidget(int x, int y, Collection<TeamMember> members, PlayerManagementButtons buttonSettings, Component message) {
        super(x, y, 102, 128, message);
        this.buttonSettings = buttonSettings;
        this.buttonWidgets = new ArrayList<DraggableWidgetImageButton>();
        int i = 0;
        for (Map.Entry<PlayerManagementButtonType, WidgetSprites> entry : this.buttonSettings.getSprites().entrySet()) {
            this.buttonWidgets.add(new DraggableWidgetImageButton(this.getX() + 6 + i * 14, this.getY() + 6, 12, 12, entry.getValue(), btn -> {}));
            ++i;
        }
        ArrayList<PlayerManagementList.Entry> entries = new ArrayList<PlayerManagementList.Entry>();
        for (TeamMember member : members) {
            entries.add(new PlayerManagementList.Entry(member, buttonSettings));
        }
        this.managementList = new PlayerManagementList(85, 118, 85, 16, entries, false, this);
        this.managementList.active = this.visible;
        this.managementList.setPosition(x + 5, y + 5);
        this.popupWidget = new WarningPopupWidget(0, 0, this::onOkPress, this::onCancelPress);
        this.popupWidget.visible = false;
        this.refreshFunction = (a, b) -> {};
    }

    public void openPopupWidget(TeamMember profile) {
        this.popupWidget.setTitle((Component)Component.literal((String)"Transfer Ownership"));
        this.popupWidget.setBodyText(List.of(Component.literal((String)"Are you sure you"), Component.literal((String)"want to transfer ownership"), Component.literal((String)"to %s".formatted(PlayerUtils.getPlayerNameFromUUID((Level)Minecraft.getInstance().level, (UUID)profile.player())))));
        this.popupWidget.visible = true;
        this.popupWidget.nextOwner = profile;
    }

    private void onCancelPress(Button button) {
        this.popupWidget.visible = false;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.managementList.active = visible;
        this.managementList.visible = visible;
    }

    public void visitWidgets(Consumer<AbstractWidget> consumer) {
        super.visitWidgets(consumer);
        consumer.accept(this.managementList);
        consumer.accept(this.popupWidget);
    }

    @Override
    protected void onMoved() {
        super.onMoved();
        int i = 0;
        for (DraggableWidgetImageButton button : this.buttonWidgets) {
            button.setPosition(this.getX() + 5 + i * 14, this.getY() + 5);
            ++i;
        }
        this.managementList.setPosition(this.getX() + 5, this.getY() + 5);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.popupWidget.visible) {
            return this.popupWidget.mouseClicked(mouseX, mouseY, button);
        }
        return this.managementList.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return true;
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float v) {
        super.renderWidget(guiGraphics, mouseX, mouseY, v);
        this.popupWidget.setPosition((guiGraphics.guiWidth() - this.popupWidget.getWidth()) / 2, (guiGraphics.guiHeight() - this.popupWidget.getHeight()) / 2);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 500.0f);
        GuiUtils.drawImg((GuiGraphics)guiGraphics, (ResourceLocation)WINDOW_TEXTURE, (int)this.getX(), (int)this.getY(), (int)this.getWidth(), (int)this.getHeight());
        poseStack.popPose();
        this.managementList.render(guiGraphics, mouseX, mouseY, v);
    }

    private void onOkPress(Button btn) {
        this.popupWidget.visible = false;
        ClientResearchTeamHelper.transferOwnershipSynced(this.popupWidget.nextOwner);
        Minecraft.getInstance().setScreen((Screen)new ResearchTeamScreen());
    }

    public record PlayerManagementButtons(boolean removeMembers, boolean promoteMembers, boolean demoteMembers, boolean transferOwnership, boolean invitePlayer) {
        public static final WidgetSprites REMOVE_MEMBERS_SPRITES = new WidgetSprites(Researchd.rl("remove_member"), Researchd.rl("remove_member_focused"));
        public static final WidgetSprites PROMOTE_MEMBERS_SPRITES = new WidgetSprites(Researchd.rl("promote_member"), Researchd.rl("promote_member_focused"));
        public static final WidgetSprites DEMOTE_MEMBERS_SPRITES = new WidgetSprites(Researchd.rl("demote_member"), Researchd.rl("demote_member_focused"));
        public static final WidgetSprites TRANSFER_OWNERSHIP_SPRITES = new WidgetSprites(Researchd.rl("transfer_ownership"), Researchd.rl("transfer_ownership_focused"));
        public static final WidgetSprites INVITE_PLAYER_SPRITES = new WidgetSprites(Researchd.rl("invite_button"), Researchd.rl("invite_button_focused"));

        public Map<PlayerManagementButtonType, WidgetSprites> getSprites() {
            LinkedHashMap<PlayerManagementButtonType, WidgetSprites> sprites = new LinkedHashMap<PlayerManagementButtonType, WidgetSprites>(4);
            if (this.removeMembers()) {
                sprites.put(PlayerManagementButtonType.REMOVE, REMOVE_MEMBERS_SPRITES);
            }
            if (this.demoteMembers()) {
                sprites.put(PlayerManagementButtonType.DEMOTE, DEMOTE_MEMBERS_SPRITES);
            }
            if (this.promoteMembers()) {
                sprites.put(PlayerManagementButtonType.PROMOTE, PROMOTE_MEMBERS_SPRITES);
            }
            if (this.transferOwnership()) {
                sprites.put(PlayerManagementButtonType.TRANSFER_OWNERSHIP, TRANSFER_OWNERSHIP_SPRITES);
            }
            if (this.invitePlayer()) {
                sprites.put(PlayerManagementButtonType.INVITE_PLAYER, INVITE_PLAYER_SPRITES);
            }
            return sprites;
        }
    }

    public static enum PlayerManagementButtonType {
        REMOVE,
        DEMOTE,
        PROMOTE,
        TRANSFER_OWNERSHIP,
        INVITE_PLAYER;

    }
}

