/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.screens.team.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.portingdeadmods.portingdeadlibs.utils.renderers.GuiUtils;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.team.TeamMember;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class WarningPopupWidget
extends AbstractWidget {
    public static final ResourceLocation TEXTURE = Researchd.rl("textures/gui/popup_window.png");
    private Component title;
    private List<Component> bodyText;
    private final Button acceptButton;
    private final Button cancelButton;
    public TeamMember nextOwner;

    public WarningPopupWidget(int x, int y, Button.OnPress confirmButtonOnPress, Button.OnPress cancelButtonOnPress) {
        super(x, y, 160, 96, (Component)Component.empty());
        this.acceptButton = Button.builder((Component)Component.literal((String)"Ok"), (Button.OnPress)confirmButtonOnPress).bounds(x + this.width / 2, y + this.height / 2, 48, 16).build();
        this.cancelButton = Button.builder((Component)Component.literal((String)"Cancel"), (Button.OnPress)cancelButtonOnPress).bounds(x + this.width / 2 + 48, y + this.height / 2, 48, 16).build();
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 1.0f);
        GuiUtils.drawImg((GuiGraphics)guiGraphics, (ResourceLocation)TEXTURE, (int)this.getX(), (int)this.getY(), (int)this.width, (int)this.height);
        Font font = Minecraft.getInstance().font;
        guiGraphics.drawCenteredString(font, this.title, this.getX() + this.width / 2, this.getY() + 4, -1);
        for (int i = 0; i < this.bodyText.size(); ++i) {
            int n = this.getX() + this.width / 2;
            int n2 = this.getY() + 8;
            Objects.requireNonNull(font);
            guiGraphics.drawCenteredString(font, this.bodyText.get(i), n, n2 + ((i + 1) * 9 + 2), -1);
        }
        this.acceptButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.cancelButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        poseStack.popPose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.acceptButton.isHovered()) {
            this.acceptButton.mouseClicked(mouseX, mouseY, button);
        } else if (this.cancelButton.isHovered()) {
            this.cancelButton.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void setPosition(int x, int y) {
        super.setPosition(x, y);
        this.acceptButton.setPosition(x + 24, y + this.height - 40);
        this.cancelButton.setPosition(x + this.width - 24 - this.cancelButton.getWidth(), y + this.height - 40);
    }

    public void setTitle(Component title) {
        this.title = title;
    }

    public void setBodyText(List<Component> bodyText) {
        this.bodyText = bodyText;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

