/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.client.utils;

import com.portingdeadmods.portingdeadlibs.cache.AllPlayersCache;
import com.portingdeadmods.portingdeadlibs.utils.PlayerUtils;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.client.ResearchGraph;
import com.portingdeadmods.researchd.api.client.TechList;
import com.portingdeadmods.researchd.api.research.GlobalResearch;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.ResearchInstance;
import com.portingdeadmods.researchd.api.team.ResearchTeam;
import com.portingdeadmods.researchd.api.team.ResearchTeamRole;
import com.portingdeadmods.researchd.api.team.TeamMember;
import com.portingdeadmods.researchd.cache.CommonResearchCache;
import com.portingdeadmods.researchd.client.screens.research.ResearchScreen;
import com.portingdeadmods.researchd.client.screens.team.ResearchTeamScreen;
import com.portingdeadmods.researchd.client.screens.team.ResearchTeamSettingsScreen;
import com.portingdeadmods.researchd.client.screens.team.widgets.PlayerManagementDraggableWidget;
import com.portingdeadmods.researchd.client.screens.team.widgets.PlayerManagementList;
import com.portingdeadmods.researchd.client.screens.team.widgets.TeamMembersList;
import com.portingdeadmods.researchd.data.ResearchdSavedData;
import com.portingdeadmods.researchd.impl.team.ResearchTeamMap;
import com.portingdeadmods.researchd.networking.team.InvitePlayerPayload;
import com.portingdeadmods.researchd.networking.team.ManageMemberPayload;
import com.portingdeadmods.researchd.networking.team.ManageModeratorPayload;
import com.portingdeadmods.researchd.networking.team.TeamSetNamePayload;
import com.portingdeadmods.researchd.networking.team.TransferOwnershipPayload;
import com.portingdeadmods.researchd.utils.researches.ResearchTeamHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class ClientResearchTeamHelper {
    public static ResearchTeam getTeam() {
        LocalPlayer player = Minecraft.getInstance().player;
        return ResearchTeamHelper.getTeamByMember((Player)player);
    }

    public static ResearchTeam getTeam(UUID uuid) {
        return ResearchTeamHelper.getTeamByMember((Level)Minecraft.getInstance().level, uuid);
    }

    public static void setTeamNameSynced(String name) {
        ResearchTeam clientTeam = ClientResearchTeamHelper.getTeam();
        if (!clientTeam.getName().equals(name)) {
            clientTeam.setName(name);
            PacketDistributor.sendToServer((CustomPacketPayload)new TeamSetNamePayload(name), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static ResearchTeamRole getPlayerRole(UUID uuid) {
        ResearchTeam clientTeam = ClientResearchTeamHelper.getTeam();
        if (clientTeam.isOwner(uuid)) {
            return ResearchTeamRole.OWNER;
        }
        if (clientTeam.isModerator(uuid)) {
            return ResearchTeamRole.MODERATOR;
        }
        return ResearchTeamRole.MEMBER;
    }

    public static ResearchTeamRole getRole() {
        LocalPlayer player = Minecraft.getInstance().player;
        return ClientResearchTeamHelper.getPlayerRole(player.getUUID());
    }

    public static int getPlayerPermissionLevel(UUID uuid) {
        return ClientResearchTeamHelper.getPlayerRole(uuid).getPermissionLevel();
    }

    public static int getPlayerPermissionLevel(Player player) {
        return ClientResearchTeamHelper.getPlayerRole(player.getUUID()).getPermissionLevel();
    }

    public static Collection<TeamMember> getTeamMembers() {
        return ClientResearchTeamHelper.getTeam().getMembers();
    }

    public static List<TeamMember> getPlayersNotInTeam() {
        ResearchTeam team = ClientResearchTeamHelper.getTeam();
        return AllPlayersCache.getUUIDs().stream().filter(uuid -> !team.hasMember((UUID)uuid)).map(uuid -> new TeamMember((UUID)uuid, ResearchTeamRole.NOT_MEMBER)).toList();
    }

    public static void removeTeamMemberSynced(TeamMember memberProfile) {
        UUID id = memberProfile.player();
        ResearchTeam team = ClientResearchTeamHelper.getTeam(id);
        team.removeMember(id);
        PacketDistributor.sendToServer((CustomPacketPayload)new ManageMemberPayload(id, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        Researchd.LOGGER.debug("Remove player {}", (Object)PlayerUtils.getPlayerNameFromUUID((Level)Minecraft.getInstance().level, (UUID)memberProfile.player()));
    }

    public static void sendTeamInviteSynced(TeamMember profileToInvite) {
        UUID invited = profileToInvite.player();
        boolean remove = ClientResearchTeamHelper.getTeam().getSocialManager().containsSentInvite(invited);
        LocalPlayer player = Minecraft.getInstance().player;
        ResearchTeam team = ClientResearchTeamHelper.getTeam();
        if (remove) {
            team.getSocialManager().removeSentInvite(invited);
        } else {
            team.getSocialManager().addSentInvite(invited);
        }
        Level level = player.level();
        ResearchdSavedData.TEAM_RESEARCH.get().setData(level, (Object)((ResearchTeamMap)ResearchdSavedData.TEAM_RESEARCH.get().getData(level)));
        PacketDistributor.sendToServer((CustomPacketPayload)new InvitePlayerPayload(invited, remove), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void promoteTeamMemberSynced(TeamMember member) {
        if (Objects.requireNonNull(member.role()) == ResearchTeamRole.MEMBER) {
            ResearchTeam team = ClientResearchTeamHelper.getTeam(member.player());
            team.setRole(member.player(), ResearchTeamRole.MODERATOR);
            PacketDistributor.sendToServer((CustomPacketPayload)new ManageModeratorPayload(member.player(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        Researchd.LOGGER.debug("Promoted player {}", (Object)PlayerUtils.getPlayerNameFromUUID((Level)Minecraft.getInstance().level, (UUID)member.player()));
    }

    public static void demoteTeamMemberSynced(TeamMember memberProfile) {
        if (Objects.requireNonNull(memberProfile.role()) == ResearchTeamRole.MODERATOR) {
            ResearchTeam team = ClientResearchTeamHelper.getTeam(memberProfile.player());
            team.setRole(memberProfile.player(), ResearchTeamRole.MEMBER);
            PacketDistributor.sendToServer((CustomPacketPayload)new ManageModeratorPayload(memberProfile.player(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        Researchd.LOGGER.debug("Demoted player {}", (Object)memberProfile.player());
    }

    public static void transferOwnershipSynced(TeamMember nextOwner) {
        ResearchTeam team = ClientResearchTeamHelper.getTeam();
        team.setRole(nextOwner.player(), ResearchTeamRole.OWNER);
        PacketDistributor.sendToServer((CustomPacketPayload)new TransferOwnershipPayload(nextOwner.player()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void resolveInstances(ResearchTeam team) {
        Map<ResourceKey<Research>, ResearchInstance> researches = team.getResearches();
        for (Map.Entry<ResourceKey<Research>, ResearchInstance> research : researches.entrySet()) {
            GlobalResearch globalResearch = CommonResearchCache.GLOBAL_RESEARCHES.get(research.getKey());
            if (globalResearch != null) {
                research.setValue(research.getValue().withResearch(globalResearch));
                continue;
            }
            Researchd.LOGGER.debug("RESEARCH");
        }
    }

    public static void refreshGraphData() {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof ResearchScreen) {
            ResearchScreen screen2 = (ResearchScreen)screen;
            ResearchGraph graph = screen2.getResearchGraph();
            graph.nodes().forEach((key, node) -> node.fetchInstanceFromTeam());
        }
    }

    public static void refreshTechListData() {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof ResearchScreen) {
            ResearchScreen screen2 = (ResearchScreen)screen;
            screen2.getTechListWidget().setTechList(TechList.getClientTechList());
            screen2.getTechList().sortTechList();
        }
    }

    public static void refreshResearchQueueData() {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof ResearchScreen) {
            ResearchScreen screen2 = (ResearchScreen)screen;
            screen2.getResearchQueueWidget().setQueue(ClientResearchTeamHelper.getTeam().getQueue());
        }
    }

    public static void refreshResearchScreenData() {
        ClientResearchTeamHelper.refreshGraphData();
        ClientResearchTeamHelper.refreshTechListData();
        ClientResearchTeamHelper.refreshResearchQueueData();
    }

    public static void refreshTeamScreenData() {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof ResearchTeamScreen) {
            ResearchTeamScreen screen2 = (ResearchTeamScreen)screen;
            PlayerManagementDraggableWidget inviteWidget = screen2.getInviteWidget();
            if (inviteWidget != null && !inviteWidget.getManagementList().getItems().isEmpty()) {
                ArrayList<PlayerManagementList.Entry> entries = new ArrayList<PlayerManagementList.Entry>();
                ClientResearchTeamHelper.getPlayersNotInTeam().forEach(member -> entries.add(new PlayerManagementList.Entry((TeamMember)member, ((PlayerManagementList.Entry)inviteWidget.getManagementList().getItems().stream().findFirst().get()).buttonSettings())));
                inviteWidget.getManagementList().refreshEntries(entries);
            }
            TeamMembersList teamMembersList = screen2.getTeamMembersList();
            teamMembersList.getItems().clear();
            teamMembersList.getItems().addAll(ClientResearchTeamHelper.getTeamMembers());
            teamMembersList.resort();
            System.out.println(teamMembersList.getItems().size());
        }
    }

    public static void refreshTeamSettingsScreenData() {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof ResearchTeamSettingsScreen) {
            PlayerManagementDraggableWidget transferOwnershipWindow;
            ResearchTeamSettingsScreen screen2 = (ResearchTeamSettingsScreen)screen;
            PlayerManagementDraggableWidget playerManagementWindow = screen2.getPlayerManagementWindow();
            if (playerManagementWindow != null && !playerManagementWindow.getManagementList().getItems().isEmpty()) {
                ArrayList<PlayerManagementList.Entry> entries = new ArrayList<PlayerManagementList.Entry>();
                ClientResearchTeamHelper.getTeamMembers().forEach(member -> entries.add(new PlayerManagementList.Entry((TeamMember)member, ((PlayerManagementList.Entry)playerManagementWindow.getManagementList().getItems().stream().findFirst().get()).buttonSettings())));
                playerManagementWindow.getManagementList().refreshEntries(entries);
            }
            if ((transferOwnershipWindow = screen2.getTransferOwnershipWindow()) != null && !transferOwnershipWindow.getManagementList().getItems().isEmpty()) {
                ArrayList<PlayerManagementList.Entry> entries = new ArrayList<PlayerManagementList.Entry>();
                ClientResearchTeamHelper.getTeamMembers().forEach(member -> entries.add(new PlayerManagementList.Entry((TeamMember)member, ((PlayerManagementList.Entry)transferOwnershipWindow.getManagementList().getItems().stream().findFirst().get()).buttonSettings())));
                transferOwnershipWindow.getManagementList().refreshEntries(entries);
            }
        }
    }

    public static void refreshResearchTeamScreenData() {
        ClientResearchTeamHelper.refreshTeamScreenData();
        ClientResearchTeamHelper.refreshTeamSettingsScreenData();
    }
}

