/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.compat;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public final class JEICompat {
    public static IJeiRuntime RUNTIME;

    public static void openRecipes(Collection<RecipeHolder<?>> recipes) {
        RegistryAccess access = Minecraft.getInstance().level.registryAccess();
        JEICompat.openRecipes(recipes.stream().map(RecipeHolder::value).map(r -> r.getResultItem((HolderLookup.Provider)access)).toList());
    }

    public static void openRecipes(List<ItemStack> results) {
        if (RUNTIME != null) {
            IFocusFactory focusFactory = RUNTIME.getJeiHelpers().getFocusFactory();
            IIngredientManager ingredientManager = RUNTIME.getIngredientManager();
            HashMap<Item, IFocus> focuses = new HashMap<Item, IFocus>();
            for (ItemStack result : results) {
                Optional ingredient = ingredientManager.createTypedIngredient((Object)result, false);
                if (!ingredient.isPresent()) continue;
                focuses.put(result.getItem(), focusFactory.createFocus(RecipeIngredientRole.OUTPUT, (ITypedIngredient)ingredient.get()));
            }
            IRecipesGui recipesGui = RUNTIME.getRecipesGui();
            recipesGui.show(List.copyOf(focuses.values()));
        }
    }
}

