/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.compat;

import com.portingdeadmods.portingdeadlibs.utils.Result;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.api.research.Research;
import com.portingdeadmods.researchd.api.research.packs.ResearchPack;
import com.portingdeadmods.researchd.compat.kubejs.ResearchdKJSEvents;
import dev.latvian.mods.kubejs.KubeJSPaths;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.ModList;

public final class KubeJSCompat {
    private static final String KUBEJS_MOD_ID = "kubejs";
    private static boolean kubeJSLoaded = false;
    private static boolean checked = false;
    public static final String EXAMPLE_CODE = "ResearchdEvents.registerResearchPacks(event => {\n    event.create('kubejs:example_pack')\n        .colorRGB(255, 51, 51)\n        .sortingValue(1); // Progression/Sorting order. Higher -> Later in game\n});\n\nResearchdEvents.registerResearches(event => {\n    event.create('kubejs:start_research')\n        .icon('minecraft:book')\n        .consumeItem('minecraft:dirt', 1)\n        .effect(ResearchEffectHelper.empty())\n        .literalName('Getting Started')\n        .literalDescription('A simple starting research.')\n        .noParentRequired();\n\n    event.create('kubejs:automation_research')\n        .icon('minecraft:iron_ingot')\n        .parent('kubejs:start_research')\n        .consumePack('kubejs:example_pack', 10, 5)\n        .effect(ResearchEffectHelper.unlockRecipe('minecraft:hopper'))\n        .literalName('Basic Automation')\n        .literalDescription('Learn the fundamentals of automated production.');\n});\n";

    public static boolean isKubeJSLoaded() {
        if (!checked) {
            kubeJSLoaded = ModList.get().isLoaded(KUBEJS_MOD_ID);
            checked = true;
        }
        return kubeJSLoaded;
    }

    public static Result<Path, Exception> createExample() {
        Path directory = KubeJSPaths.SERVER_SCRIPTS;
        try {
            if (Files.exists(directory, new LinkOption[0])) {
                Path exampleFile = directory.resolve("research_examples.js");
                if (Files.notExists(exampleFile, new LinkOption[0])) {
                    Files.writeString(exampleFile, (CharSequence)EXAMPLE_CODE, new OpenOption[0]);
                    return Result.ok((Object)exampleFile);
                }
                return Result.err((Exception)new Exception("File already exists"));
            }
            return Result.err((Exception)new Exception("KubeJS server_scripts directory doesn't exist"));
        }
        catch (IOException e) {
            Researchd.LOGGER.error("Failed to create KubeJS Examples", (Throwable)e);
            return Result.err((Exception)new Exception("File creation failed"));
        }
    }

    public static Path getServerScriptsDir() {
        return KubeJSPaths.SERVER_SCRIPTS;
    }

    public static void fireResearchCompletedEvent(ServerPlayer player, ResourceKey<Research> research) {
        if (KubeJSCompat.isKubeJSLoaded()) {
            try {
                ResearchdKJSEvents.fireResearchCompleted(player, research);
            }
            catch (Exception e) {
                Researchd.LOGGER.error("Failed to fire KubeJS research completed event", (Throwable)e);
            }
        }
    }

    public static void fireResearchProgressEvent(ServerPlayer player, ResourceKey<Research> research, double progress) {
        if (KubeJSCompat.isKubeJSLoaded()) {
            try {
                ResearchdKJSEvents.fireResearchProgress(player, research, progress);
            }
            catch (Exception e) {
                Researchd.LOGGER.error("Failed to fire KubeJS research progress event", (Throwable)e);
            }
        }
    }

    public static Map<ResourceLocation, Research> getKubeJSResearches() {
        if (!KubeJSCompat.isKubeJSLoaded()) {
            return Map.of();
        }
        try {
            return ResearchdKJSEvents.fireRegisterResearchesEvent();
        }
        catch (Exception e) {
            Researchd.LOGGER.error("Failed to get KubeJS researches", (Throwable)e);
            return Map.of();
        }
    }

    public static Map<ResourceLocation, ResearchPack> getKubeJSResearchPacks() {
        if (!KubeJSCompat.isKubeJSLoaded()) {
            return Map.of();
        }
        try {
            return ResearchdKJSEvents.fireRegisterResearchPacksEvent();
        }
        catch (Exception e) {
            Researchd.LOGGER.error("Failed to get KubeJS research packs", (Throwable)e);
            return Map.of();
        }
    }

    private static class KubeJSEventHandler {
        private KubeJSEventHandler() {
        }
    }
}

