/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.compat.kubejs.event;

import com.portingdeadmods.researchd.ResearchdRegistries;
import com.portingdeadmods.researchd.api.research.packs.ResearchPack;
import com.portingdeadmods.researchd.compat.kubejs.builders.ResearchPackBuilder;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.script.SourceLine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class RegisterResearchPacksKubeEvent
implements KubeEvent {
    private final Map<ResourceLocation, ResearchPack> researchPacks = new HashMap<ResourceLocation, ResearchPack>();
    private final List<ResearchPackBuilder> builders = new ArrayList<ResearchPackBuilder>();

    public ResearchPackBuilder create(String id) {
        ResourceLocation location = ResourceLocation.parse((String)id);
        ResearchPackBuilder builder = new ResearchPackBuilder(location);
        builder.sourceLine = SourceLine.UNKNOWN;
        this.builders.add(builder);
        return builder;
    }

    public ItemStack createItem(String packId) {
        ResourceLocation location = ResourceLocation.parse((String)packId);
        ResourceKey key = ResourceKey.create(ResearchdRegistries.RESEARCH_PACK_KEY, (ResourceLocation)location);
        return ResearchPack.asStack((ResourceKey<ResearchPack>)key);
    }

    public Map<ResourceLocation, ResearchPack> getResearchPacks() {
        for (ResearchPackBuilder builder : this.builders) {
            try {
                ResearchPack pack = builder.createObject();
                this.researchPacks.put(builder.id, pack);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create research pack " + String.valueOf(builder.id), e);
            }
        }
        return this.researchPacks;
    }
}

