/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.content.blockentities;

import com.portingdeadmods.portingdeadlibs.utils.LazyFinal;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.content.blockentities.ResearchLabControllerBE;
import com.portingdeadmods.researchd.registries.ResearchdBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class ResearchLabPartBE
extends BlockEntity {
    private final LazyFinal<BlockPos> controllerPos = new LazyFinal();

    public ResearchLabPartBE(BlockPos pos, BlockState blockState) {
        super(ResearchdBlockEntityTypes.RESEARCH_LAB_PART.get(), pos, blockState);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("ControllerPos")) {
            this.setControllerPos(BlockPos.of((long)tag.getLong("ControllerPos")));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.controllerPos.ifInitialized(pos -> tag.putLong("ControllerPos", ((BlockPos)this.controllerPos.getOrThrow()).asLong()));
    }

    public void setControllerPos(BlockPos controllerPos) {
        if (!this.controllerPos.isInitialized()) {
            this.controllerPos.initialize((Object)controllerPos);
        } else {
            Researchd.debug("Research Lab Part BE", "Controller position is already set to: " + String.valueOf(this.controllerPos.getOrThrow()) + ", ignoring new value: " + String.valueOf(controllerPos));
        }
    }

    public BlockPos getControllerPos() {
        return (BlockPos)this.controllerPos.getOrThrow();
    }

    @Nullable
    public IItemHandler exposeItemHandler(@Nullable Direction context) {
        if (context == Direction.DOWN) {
            return null;
        }
        if (!this.controllerPos.isInitialized()) {
            return null;
        }
        Level level = this.getLevel();
        if (level == null) {
            return null;
        }
        BlockEntity be = level.getBlockEntity(this.getControllerPos());
        if (be instanceof ResearchLabControllerBE) {
            ResearchLabControllerBE controller = (ResearchLabControllerBE)be;
            if (!controller.shouldExposeHandler(this)) {
                return null;
            }
            return controller.getItemHandler();
        }
        return null;
    }
}

