/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.content.blocks;

import com.mojang.serialization.MapCodec;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.content.blockentities.ResearchLabControllerBE;
import com.portingdeadmods.researchd.content.blockentities.ResearchLabPartBE;
import com.portingdeadmods.researchd.content.blocks.ResearchLabController;
import com.portingdeadmods.researchd.registries.ResearchdItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResearchLabPart
extends BaseEntityBlock {
    public ResearchLabPart(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel sl = (ServerLevel)level;
        ServerPlayer sp = (ServerPlayer)player;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ResearchLabPartBE) {
            ResearchLabPartBE researchLabPartBE = (ResearchLabPartBE)blockEntity;
            BlockEntity blockEntity2 = sl.getBlockEntity(researchLabPartBE.getControllerPos());
            if (blockEntity2 instanceof ResearchLabControllerBE) {
                ResearchLabControllerBE controllerBE = (ResearchLabControllerBE)blockEntity2;
                sp.openMenu((MenuProvider)controllerBE, researchLabPartBE.getControllerPos());
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ResearchLabPartBE) {
            ResearchLabPartBE partBE = (ResearchLabPartBE)blockEntity;
            BlockPos controllerPos = partBE.getControllerPos();
            Block block = level.getBlockState(controllerPos).getBlock();
            if (block instanceof ResearchLabController) {
                ResearchLabController controller = (ResearchLabController)block;
                Researchd.debug("Research Lab Part", "Removing part at " + String.valueOf(pos) + " and its controller at " + String.valueOf(controllerPos));
                level.removeBlock(controllerPos, false);
                level.removeBlockEntity(controllerPos);
            }
        } else {
            Researchd.debug("Research Lab Part", "Block entity at " + String.valueOf(pos) + " is not an instance of ResearchLabPartBE, skipping removal of parts.");
        }
    }

    @NotNull
    public MapCodec<? extends BaseEntityBlock> codec() {
        return ResearchLabPart.simpleCodec(ResearchLabPart::new);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ResearchLabPartBE(blockPos, blockState);
    }

    @NotNull
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return ResearchdItems.RESEARCH_LAB.toStack();
    }
}

