/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.content.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.portingdeadmods.researchd.api.research.effects.ResearchEffectData;
import com.portingdeadmods.researchd.utils.researches.ResearchHelperCommon;
import com.portingdeadmods.researchd.utils.researches.ResearchTeamHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class DebugCommands {
    public static LiteralCommandNode<CommandSourceStack> build() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"debug").requires(p -> p.hasPermission(2))).then(Commands.literal((String)"teams-dump").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            source.sendSystemMessage(ResearchTeamHelper.getFormattedDump((Level)source.getLevel()));
            return 1;
        }))).then(Commands.literal((String)"data-dump").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            if (source.getPlayer() != null) {
                DebugCommands.displayPlayerPredicates(source.getPlayer());
            }
            return 1;
        }))).build();
    }

    private static void displayPlayerPredicates(ServerPlayer player) {
        MutableComponent header = Component.literal((String)"------ RESEARCHD PLAYER DATA ------").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD});
        player.sendSystemMessage((Component)header);
        MutableComponent playerInfo = Component.literal((String)"Player: ").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)player.getName().getString()).withStyle(ChatFormatting.YELLOW));
        player.sendSystemMessage((Component)playerInfo);
        for (ResearchEffectData<?> data : ResearchHelperCommon.getResearchEffectData(player)) {
            MutableComponent effect = Component.literal((String)data.getClass().getSimpleName()).withStyle(ChatFormatting.GREEN);
            for (Object entry : data.getAll()) {
                effect.append((Component)Component.literal((String)("\n  - " + entry.toString())).withStyle(ChatFormatting.WHITE));
            }
            player.sendSystemMessage((Component)effect);
        }
        MutableComponent footer = Component.literal((String)"----------- END OF DATA -----------").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD});
        player.sendSystemMessage((Component)footer);
    }
}

