/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.content.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.portingdeadmods.portingdeadlibs.utils.UniqueArray;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;

public class DevCommands {
    public static LiteralCommandNode<CommandSourceStack> build(CommandBuildContext context) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dev").requires(p -> p.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"recipes-dump").then(Commands.literal((String)"results").then(Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)context)).executes(ctx -> DevCommands.dumpRecipes((CommandContext<CommandSourceStack>)ctx, DumpRecipesMode.RESULTS))))).then(Commands.literal((String)"contains").then(Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)context)).executes(ctx -> DevCommands.dumpRecipes((CommandContext<CommandSourceStack>)ctx, DumpRecipesMode.CONTAINS))))).then(Commands.literal((String)"all").then(Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)context)).executes(ctx -> DevCommands.dumpRecipes((CommandContext<CommandSourceStack>)ctx, DumpRecipesMode.ALL)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"dimensions-dump").then(Commands.literal((String)"current").executes(DevCommands::dumpCurrentDimension))).then(Commands.literal((String)"all").executes(DevCommands::dumpAllDimensions)))).build();
    }

    private static int dumpCurrentDimension(CommandContext<CommandSourceStack> ctx) {
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        String dimensionId = level.dimension().location().toString();
        ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"Current Dimension: ").append((Component)Component.literal((String)dimensionId).withStyle(ChatFormatting.GREEN)).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, dimensionId)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to copy dimension ID")))));
        return 1;
    }

    private static int dumpAllDimensions(CommandContext<CommandSourceStack> ctx) {
        List<ResourceLocation> levels = ((CommandSourceStack)ctx.getSource()).levels().stream().map(ResourceKey::location).toList();
        ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"Found ").append((Component)Component.literal((String)String.valueOf(levels.size())).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)(" Dimension" + (levels.size() == 1 ? "" : "s") + ":"))).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, levels.toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to copy all dimension IDs")))));
        for (ResourceLocation dimensionId : levels) {
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("- " + String.valueOf(dimensionId))).withStyle(ChatFormatting.GRAY).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, dimensionId.toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to copy dimension ID")))));
        }
        return 1;
    }

    private static int dumpRecipes(CommandContext<CommandSourceStack> ctx, DumpRecipesMode mode) {
        ItemInput item = (ItemInput)ctx.getArgument("item", ItemInput.class);
        return DevCommands.findAndDisplayRecipes((CommandSourceStack)ctx.getSource(), mode, item.getItem());
    }

    private static int findAndDisplayRecipes(CommandSourceStack source, DumpRecipesMode mode, Item item) {
        ServerPlayer player = source.getPlayer();
        if (player == null) {
            return 0;
        }
        RecipeManager recipeManager = source.getLevel().getRecipeManager();
        List<RecipeHolder<?>> matchingRecipes = DevCommands.findRecipes(recipeManager, item, mode, source);
        if (matchingRecipes.isEmpty()) {
            source.sendSystemMessage((Component)Component.literal((String)"No recipes found for: ").append(item.getDefaultInstance().getHoverName()));
        } else {
            DevCommands.displayRecipes(source, player, matchingRecipes, item, arg_0 -> ((CommandSourceStack)source).sendSystemMessage(arg_0), mode);
        }
        return 1;
    }

    private static List<RecipeHolder<?>> findRecipes(RecipeManager recipeManager, Item item, DumpRecipesMode mode, CommandSourceStack source) {
        Predicate<RecipeHolder> filter = switch (mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> recipeHolder -> {
                Recipe recipe = recipeHolder.value();
                ItemStack result = recipe.getResultItem((HolderLookup.Provider)source.getLevel().registryAccess());
                return !result.isEmpty() && result.is(item);
            };
            case 1 -> recipeHolder -> {
                Recipe recipe = recipeHolder.value();
                UniqueArray ingredients = new UniqueArray();
                recipe.getIngredients().forEach(ingredient -> ingredients.addAll((Object[])ingredient.getItems()));
                for (ItemStack ingredient2 : ingredients) {
                    if (!ingredient2.is(item)) continue;
                    return true;
                }
                return false;
            };
            case 2 -> recipeHolder -> {
                boolean resultMatches;
                Recipe recipe = recipeHolder.value();
                ItemStack result = recipe.getResultItem((HolderLookup.Provider)source.getLevel().registryAccess());
                boolean bl = resultMatches = !result.isEmpty() && result.is(item);
                if (resultMatches) {
                    return true;
                }
                UniqueArray ingredients = new UniqueArray();
                recipe.getIngredients().forEach(ingredient -> ingredients.addAll((Object[])ingredient.getItems()));
                for (ItemStack ingredient2 : ingredients) {
                    if (!ingredient2.is(item)) continue;
                    return true;
                }
                return false;
            };
        };
        return recipeManager.getRecipes().stream().filter(filter).toList();
    }

    private static void displayRecipes(CommandSourceStack source, ServerPlayer player, List<RecipeHolder<?>> matchingRecipes, Item item, Consumer<Component> sendMessageFunc, DumpRecipesMode mode) {
        StringBuilder builder = new StringBuilder();
        String headerComment = switch (mode.ordinal()) {
            case 0 -> "/** All the recipes resulting in " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)item));
            case 1 -> "/** All the recipes containing " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)item));
            default -> "/** All the recipes containing or requiring " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)item));
        };
        builder.append(headerComment).append("*/\n");
        builder.append("new AndResearchEffect(\n");
        builder.append("List.of(\n");
        for (RecipeHolder<?> recipeHolder : matchingRecipes) {
            builder.append("new RecipeUnlockEffect(ResourceLocation.parse(");
            String recipeId = recipeHolder.id().toString();
            builder.append('\"').append(recipeId).append('\"');
            builder.append(matchingRecipes.indexOf(recipeHolder) == matchingRecipes.size() - 1 ? "))\n" : ")),\n");
        }
        builder.append("))");
        String messageType = switch (mode.ordinal()) {
            case 0 -> " recipes for: ";
            case 1 -> " recipes containing: ";
            default -> " recipes that result or contain: ";
        };
        MutableComponent recipeIdsComponent = Component.literal((String)"").append((Component)Component.literal((String)"Found ")).append((Component)Component.literal((String)("" + matchingRecipes.size())).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)messageType)).append((Component)Component.literal((String)item.getDefaultInstance().getHoverName().getString()).withStyle(ChatFormatting.GREEN)).setStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, builder.toString())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to copy recipes ID"))));
        sendMessageFunc.accept((Component)recipeIdsComponent);
    }

    public static enum DumpRecipesMode {
        RESULTS,
        CONTAINS,
        ALL;

    }
}

