/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.content.items;

import com.portingdeadmods.portingdeadlibs.utils.AABBUtils;
import com.portingdeadmods.portingdeadlibs.utils.UniqueArray;
import com.portingdeadmods.researchd.Researchd;
import com.portingdeadmods.researchd.content.blockentities.ResearchLabControllerBE;
import com.portingdeadmods.researchd.content.blockentities.ResearchLabPartBE;
import com.portingdeadmods.researchd.content.blocks.ResearchLabController;
import com.portingdeadmods.researchd.content.blocks.ResearchLabPart;
import com.portingdeadmods.researchd.data.ResearchdAttachments;
import com.portingdeadmods.researchd.registries.ResearchdBlocks;
import com.portingdeadmods.researchd.utils.Spaghetti;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class ResearchLabItem
extends BlockItem {
    public ResearchLabItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @NotNull
    public InteractionResult place(BlockPlaceContext context) {
        return super.place(context);
    }

    public boolean placeBlock(BlockPlaceContext context, BlockState state) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (level.isClientSide()) {
            return true;
        }
        if (player == null) {
            return false;
        }
        Researchd.debug("Research Lab", "Placing Research Lab at " + String.valueOf(context.getClickedPos()));
        BlockPos controllerPos = context.getClickedPos().offset(context.getHorizontalDirection().getNormal());
        BlockPos center = controllerPos.offset(Direction.UP.getNormal());
        AABB aabb = AABBUtils.create((double)1.0, (double)1.0, (double)1.0, (double)1.0, (double)1.0, (double)1.0, (BlockPos)center);
        Spaghetti.printAABB(aabb);
        UniqueArray allPos = AABBUtils.getAllPositionsInAABB((AABB)aabb);
        Researchd.debug("Research Lab", "Found " + allPos.size() + " positions in AABB: " + String.valueOf(aabb));
        allPos.forEach(pos -> {
            if (pos.equals((Object)controllerPos)) {
                level.setBlockAndUpdate(pos, ((ResearchLabController)((Object)((Object)ResearchdBlocks.RESEARCH_LAB_CONTROLLER.get()))).defaultBlockState());
            } else {
                level.setBlockAndUpdate(pos, ((ResearchLabPart)((Object)((Object)ResearchdBlocks.RESEARCH_LAB_PART.get()))).defaultBlockState());
                ResearchLabPartBE rlp = (ResearchLabPartBE)level.getBlockEntity(pos);
                rlp.setControllerPos(controllerPos);
            }
            level.getBlockEntity(pos).setData(ResearchdAttachments.PLACED_BY_UUID, (Object)(player != null ? player.getUUID() : null));
        });
        allPos.remove((Object)controllerPos);
        BlockEntity blockEntity = level.getBlockEntity(controllerPos);
        if (blockEntity instanceof ResearchLabControllerBE) {
            ResearchLabControllerBE controller = (ResearchLabControllerBE)blockEntity;
            controller.setPartPositions((List<BlockPos>)allPos);
            Researchd.debug("Research Lab", "Set part positions for controller at " + String.valueOf(controllerPos) + ": " + String.valueOf(allPos));
        }
        return true;
    }

    public boolean canPlace(BlockPlaceContext context, BlockState state) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        AABB aabb = AABBUtils.create((double)1.0, (double)1.0, (double)1.0, (double)1.0, (double)1.0, (double)1.0, (BlockPos)context.getClickedPos().above());
        AABBUtils.move((AABB)aabb, (Direction)context.getHorizontalDirection(), (double)1.0);
        AABBUtils.move((AABB)aabb, (Direction)Direction.UP, (double)1.0);
        UniqueArray allPos = AABBUtils.getAllPositionsInAABB((AABB)aabb);
        List<BlockPos> badPos = allPos.stream().filter(pos -> !level.getBlockState(pos).canBeReplaced()).toList();
        if (badPos.isEmpty()) {
            Researchd.debug("Research Lab", "Can place at " + String.valueOf(context.getClickedPos()));
            return true;
        }
        Researchd.debug("Research Lab", "Cannot place at " + String.valueOf(context.getClickedPos()));
        Researchd.debug("Research Lab", "Bad positions: ");
        badPos.forEach(pos -> Researchd.debug("Research Lab", pos.getX(), ", ", pos.getY(), ", ", pos.getZ(), " is ", level.getBlockState(pos).getBlock().getClass().getSimpleName()));
        return false;
    }
}

