/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.researchd.events;

import com.portingdeadmods.portingdeadlibs.utils.UniqueArray;
import com.portingdeadmods.researchd.ResearchdClientConfig;
import com.portingdeadmods.researchd.api.research.packs.ResearchPack;
import com.portingdeadmods.researchd.client.ResearchdKeybinds;
import com.portingdeadmods.researchd.client.cache.ResearchGraphCache;
import com.portingdeadmods.researchd.client.screens.research.ResearchScreen;
import com.portingdeadmods.researchd.client.screens.team.ResearchTeamScreen;
import com.portingdeadmods.researchd.data.ResearchdAttachments;
import com.portingdeadmods.researchd.impl.research.effect.data.RecipeUnlockEffectData;
import com.portingdeadmods.researchd.translations.ResearchdTranslations;
import com.portingdeadmods.researchd.utils.researches.ResearchHelperCommon;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="researchd", value={Dist.CLIENT})
public final class ResearchdClientEvents {
    @SubscribeEvent
    public static void preClientTick(ClientTickEvent.Pre event) {
        if (((KeyMapping)ResearchdKeybinds.OPEN_RESEARCH_SCREEN.get()).consumeClick()) {
            Minecraft.getInstance().setScreen((Screen)new ResearchScreen());
        }
        if (((KeyMapping)ResearchdKeybinds.OPEN_RESEARCH_TEAM_SCREEN.get()).consumeClick()) {
            Minecraft.getInstance().setScreen((Screen)new ResearchTeamScreen());
        }
    }

    @SubscribeEvent
    public static void onToolTipEvent(ItemTooltipEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        LocalPlayer player = (LocalPlayer)event.getEntity();
        Item item = event.getItemStack().getItem();
        RecipeUnlockEffectData recipeData = (RecipeUnlockEffectData)player.getData(ResearchdAttachments.RECIPE_PREDICATE.get());
        UniqueArray blockedItems = new UniqueArray();
        recipeData.blockedRecipes().forEach(recipe -> blockedItems.add((Object)recipe.value().getResultItem((HolderLookup.Provider)player.registryAccess()).getItem()));
        if (blockedItems.contains((Object)item)) {
            event.getToolTip().add(Component.literal((String)""));
            event.getToolTip().add(Component.literal((String)"This item is blocked by a research!").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
        }
    }

    @SubscribeEvent
    public static void onClientPlayerLoggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
        LocalPlayer player = event.getPlayer();
        if (ResearchdClientConfig.showJoinMessage) {
            player.sendSystemMessage((Component)ResearchdTranslations.Game.JOIN_MESSAGE.component("researchd", new Object[0]).append((Component)Component.literal((String)"\n> ").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.BOLD})).append((Component)ResearchdTranslations.Game.GITHUB.component("researchd", new Object[0]).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Porting-Dead-Mods/Researchd")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Go to the GitHub page"))))).append((Component)Component.literal((String)"\n> ").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.BOLD})).append((Component)ResearchdTranslations.Game.WIKI.component("researchd", new Object[0]).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://porting-dead-mods.github.io/Researchd/")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Go to the Wiki"))))));
        }
        RegistryAccess registryAccess = player.registryAccess();
        Map<ResourceKey<ResearchPack>, ResearchPack> packs = ResearchHelperCommon.getResearchPacks(player.level());
    }

    @SubscribeEvent
    public static void onClientPlayerLoggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
        ResearchGraphCache.clearCache();
    }
}

